/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server;

import java.net.InetAddress;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.apache.nifi.distributed.cache.server.CacheServer;
import org.apache.nifi.event.transport.EventServer;
import org.apache.nifi.event.transport.configuration.ShutdownQuietPeriod;
import org.apache.nifi.event.transport.configuration.ShutdownTimeout;
import org.apache.nifi.event.transport.configuration.TransportProtocol;
import org.apache.nifi.event.transport.netty.NettyEventServerFactory;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.security.util.ClientAuth;

public abstract class EventCacheServer
implements CacheServer {
    private static final InetAddress ALL_ADDRESSES = null;
    private final ComponentLog log;
    private volatile int port;
    private EventServer eventServer;

    public EventCacheServer(ComponentLog log, int port) {
        this.log = Objects.requireNonNull(log, "Component Log required");
        this.port = port;
    }

    @Override
    public void start() {
        this.eventServer = this.createEventServer();
        this.port = this.eventServer.getListeningPort();
        this.log.info("Started Cache Server Port [{}]", new Object[]{this.port});
    }

    @Override
    public void stop() {
        if (this.eventServer == null) {
            this.log.info("Server not running");
        } else {
            this.eventServer.shutdown();
        }
        this.log.info("Stopped Cache Server Port [{}]", new Object[]{this.port});
    }

    @Override
    public int getPort() {
        return this.port;
    }

    protected NettyEventServerFactory createEventServerFactory(String identifier, SSLContext sslContext) {
        NettyEventServerFactory eventServerFactory = new NettyEventServerFactory(ALL_ADDRESSES, this.port, TransportProtocol.TCP);
        eventServerFactory.setSslContext(sslContext);
        eventServerFactory.setClientAuth(ClientAuth.REQUIRED);
        String threadNamePrefix = String.format("%s[%s]", this.getClass().getSimpleName(), identifier);
        eventServerFactory.setThreadNamePrefix(threadNamePrefix);
        eventServerFactory.setShutdownQuietPeriod(ShutdownQuietPeriod.QUICK.getDuration());
        eventServerFactory.setShutdownTimeout(ShutdownTimeout.QUICK.getDuration());
        return eventServerFactory;
    }

    protected abstract EventServer createEventServer();
}

