/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.set;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.distributed.cache.server.set.SetCache;
import org.apache.nifi.distributed.cache.server.set.SetCacheRecord;
import org.apache.nifi.distributed.cache.server.set.SetCacheResult;
import org.apache.nifi.wali.SequentialAccessWriteAheadLog;
import org.wali.SerDe;
import org.wali.SerDeFactory;
import org.wali.UpdateType;
import org.wali.WriteAheadRepository;

public class PersistentSetCache
implements SetCache {
    private final SetCache wrapped;
    private final WriteAheadRepository<SetRecord> wali;
    private final AtomicLong modifications = new AtomicLong(0L);

    public PersistentSetCache(String serviceIdentifier, File persistencePath, SetCache cacheToWrap) throws IOException {
        this.wali = new SequentialAccessWriteAheadLog(persistencePath, (SerDeFactory)new SerdeFactory());
        this.wrapped = cacheToWrap;
    }

    public synchronized void restore() throws IOException {
        Collection recovered = this.wali.recoverRecords();
        for (SetRecord record : recovered) {
            if (record.getUpdateType() != UpdateType.CREATE) continue;
            this.addIfAbsent(record.getBuffer());
        }
    }

    @Override
    public synchronized SetCacheResult remove(ByteBuffer value) throws IOException {
        SetCacheResult removeResult = this.wrapped.remove(value);
        if (removeResult.getResult()) {
            SetRecord record = new SetRecord(UpdateType.DELETE, value);
            ArrayList<SetRecord> records = new ArrayList<SetRecord>();
            records.add(record);
            this.wali.update(records, false);
            long modCount = this.modifications.getAndIncrement();
            if (modCount > 0L && modCount % 1000L == 0L) {
                this.wali.checkpoint();
            }
        }
        return removeResult;
    }

    @Override
    public synchronized SetCacheResult addIfAbsent(ByteBuffer value) throws IOException {
        SetCacheResult addResult = this.wrapped.addIfAbsent(value);
        if (addResult.getResult()) {
            SetRecord record = new SetRecord(UpdateType.CREATE, value);
            ArrayList<SetRecord> records = new ArrayList<SetRecord>();
            records.add(record);
            SetCacheRecord evictedRecord = addResult.getEvictedRecord();
            if (evictedRecord != null) {
                records.add(new SetRecord(UpdateType.DELETE, evictedRecord.getValue()));
            }
            this.wali.update(records, false);
            long modCount = this.modifications.getAndIncrement();
            if (modCount > 0L && modCount % 1000L == 0L) {
                this.wali.checkpoint();
            }
        }
        return addResult;
    }

    @Override
    public synchronized SetCacheResult contains(ByteBuffer value) throws IOException {
        return this.wrapped.contains(value);
    }

    @Override
    public void shutdown() throws IOException {
        this.wali.shutdown();
    }

    private static class SerdeFactory
    implements SerDeFactory<SetRecord> {
        private Serde serde = new Serde();

        public SerDe<SetRecord> createSerDe(String encodingName) {
            return this.serde;
        }

        public Object getRecordIdentifier(SetRecord record) {
            return this.serde.getRecordIdentifier(record);
        }

        public UpdateType getUpdateType(SetRecord record) {
            return this.serde.getUpdateType(record);
        }

        public String getLocation(SetRecord record) {
            return this.serde.getLocation(record);
        }
    }

    private static class SetRecord {
        private final UpdateType updateType;
        private final ByteBuffer value;

        public SetRecord(UpdateType updateType, ByteBuffer value) {
            this.updateType = updateType;
            this.value = value;
        }

        public UpdateType getUpdateType() {
            return this.updateType;
        }

        public ByteBuffer getBuffer() {
            return this.value;
        }

        public byte[] getData() {
            return this.value.array();
        }
    }

    private static class Serde
    implements SerDe<SetRecord> {
        private Serde() {
        }

        public void serializeEdit(SetRecord previousRecordState, SetRecord newRecordState, DataOutputStream out) throws IOException {
            UpdateType updateType = newRecordState.getUpdateType();
            if (updateType == UpdateType.DELETE) {
                out.write(0);
            } else {
                out.write(1);
            }
            byte[] data = newRecordState.getData();
            out.writeInt(data.length);
            out.write(newRecordState.getData());
        }

        public void serializeRecord(SetRecord record, DataOutputStream out) throws IOException {
            this.serializeEdit(null, record, out);
        }

        public SetRecord deserializeEdit(DataInputStream in, Map<Object, SetRecord> currentRecordStates, int version) throws IOException {
            int value = in.read();
            if (value < 0) {
                throw new EOFException();
            }
            UpdateType updateType = value == 0 ? UpdateType.DELETE : UpdateType.CREATE;
            int size = in.readInt();
            byte[] data = new byte[size];
            in.readFully(data);
            return new SetRecord(updateType, ByteBuffer.wrap(data));
        }

        public SetRecord deserializeRecord(DataInputStream in, int version) throws IOException {
            return this.deserializeEdit(in, (Map)new HashMap(), version);
        }

        public Object getRecordIdentifier(SetRecord record) {
            return record.getBuffer();
        }

        public UpdateType getUpdateType(SetRecord record) {
            return record.getUpdateType();
        }

        public String getLocation(SetRecord record) {
            return null;
        }

        public int getVersion() {
            return 1;
        }
    }
}

