/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.distributed.cache.client.CacheClientSerde;
import org.apache.nifi.distributed.cache.client.DistributedSetCacheClient;
import org.apache.nifi.distributed.cache.client.NettySetCacheClient;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.distributed.cache.protocol.ProtocolVersion;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.remote.StandardVersionNegotiatorFactory;
import org.apache.nifi.remote.VersionNegotiatorFactory;
import org.apache.nifi.ssl.SSLContextProvider;

@Tags(value={"distributed", "cache", "state", "set", "cluster"})
@SeeAlso(classNames={"org.apache.nifi.distributed.cache.server.SetCacheServer"})
@CapabilityDescription(value="Provides the ability to communicate with a SetCacheServer. This can be used in order to share a Set between nodes in a NiFi cluster")
public class SetCacheClientService
extends AbstractControllerService
implements DistributedSetCacheClient {
    public static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().name("Server Hostname").description("The name of the server that is running the DistributedSetCacheServer service").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Server Port").description("The port on the remote server that is to be used when communicating with the DistributedSetCacheServer service").required(true).addValidator(StandardValidators.PORT_VALIDATOR).defaultValue("4557").build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("If specified, indicates the SSL Context Service that is used to communicate with the remote server. If not specified, communications will not be encrypted").required(false).identifiesControllerService(SSLContextProvider.class).build();
    public static final PropertyDescriptor COMMUNICATIONS_TIMEOUT = new PropertyDescriptor.Builder().name("Communications Timeout").description("Specifies how long to wait when communicating with the remote server before determining that there is a communications failure if data cannot be sent or received").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("30 secs").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(HOSTNAME, PORT, SSL_CONTEXT_SERVICE, COMMUNICATIONS_TIMEOUT);
    private volatile NettySetCacheClient cacheClient = null;
    private volatile VersionNegotiatorFactory versionNegotiatorFactory = null;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.getLogger().debug("Enabling Set Cache Client Service [{}]", new Object[]{context.getName()});
        this.versionNegotiatorFactory = new StandardVersionNegotiatorFactory(new int[]{ProtocolVersion.V1.value()});
        this.cacheClient = new NettySetCacheClient(context.getProperty(HOSTNAME).getValue(), context.getProperty(PORT).asInteger(), context.getProperty(COMMUNICATIONS_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue(), (SSLContextProvider)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class), this.versionNegotiatorFactory, this.getIdentifier());
    }

    @OnDisabled
    public void onDisabled() throws IOException {
        this.getLogger().debug("Disabling Set Cache Client Service");
        this.cacheClient.close();
        this.versionNegotiatorFactory = null;
        this.cacheClient = null;
    }

    @OnStopped
    public void onStopped() throws IOException {
        if (this.isEnabled()) {
            this.onDisabled();
        }
    }

    public <T> boolean addIfAbsent(T value, Serializer<T> serializer) throws IOException {
        byte[] bytes = CacheClientSerde.serialize(value, serializer);
        return this.cacheClient.addIfAbsent(bytes);
    }

    public <T> boolean contains(T value, Serializer<T> serializer) throws IOException {
        byte[] bytes = CacheClientSerde.serialize(value, serializer);
        return this.cacheClient.contains(bytes);
    }

    public <T> boolean remove(T value, Serializer<T> serializer) throws IOException {
        byte[] bytes = CacheClientSerde.serialize(value, serializer);
        return this.cacheClient.remove(bytes);
    }

    public void close() throws IOException {
        if (this.isEnabled()) {
            this.onDisabled();
        }
    }
}

