/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client.adapter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Set;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.adapter.InboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.InboundToken;

public class SetInboundAdapter<T>
implements InboundAdapter {
    private final Deserializer<T> deserializer;
    private final ByteBuf byteBuf;
    private final InboundToken<T> inboundToken;
    private Integer size;
    private final Set<T> result;

    public SetInboundAdapter(Deserializer<T> deserializer, Set<T> result) {
        this.deserializer = deserializer;
        this.byteBuf = Unpooled.buffer();
        this.inboundToken = new InboundToken();
        this.size = null;
        this.result = result;
    }

    public Set<T> getResult() {
        return this.result;
    }

    @Override
    public boolean isComplete() {
        return this.size != null && this.result.size() >= this.size;
    }

    @Override
    public void queue(byte[] bytes) {
        this.byteBuf.writeBytes(bytes);
    }

    @Override
    public void dequeue() throws IOException {
        if (this.size == null && this.byteBuf.readableBytes() >= 4) {
            this.size = this.byteBuf.readInt();
        }
        while (this.size != null && this.result.size() < this.size) {
            this.inboundToken.update(this.byteBuf, this.deserializer);
            if (!this.inboundToken.isComplete()) break;
            this.result.add(this.inboundToken.getValue());
            this.inboundToken.reset();
        }
    }
}

