/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.nifi.distributed.cache.client.CommsSession;
import org.apache.nifi.remote.io.InterruptableInputStream;
import org.apache.nifi.remote.io.InterruptableOutputStream;
import org.apache.nifi.remote.io.socket.SocketChannelInputStream;
import org.apache.nifi.remote.io.socket.SocketChannelOutputStream;

public class StandardCommsSession
implements CommsSession {
    private final SocketChannel socketChannel = SocketChannel.open();
    private final String hostname;
    private final int port;
    private volatile long timeoutMillis;
    private final SocketChannelInputStream in;
    private final InterruptableInputStream bufferedIn;
    private final SocketChannelOutputStream out;
    private final InterruptableOutputStream bufferedOut;
    private int protocolVersion;

    public StandardCommsSession(String hostname, int port, int timeoutMillis) throws IOException {
        this.socketChannel.socket().connect(new InetSocketAddress(hostname, port), timeoutMillis);
        this.socketChannel.configureBlocking(false);
        this.in = new SocketChannelInputStream(this.socketChannel);
        this.bufferedIn = new InterruptableInputStream((InputStream)new BufferedInputStream((InputStream)this.in));
        this.out = new SocketChannelOutputStream(this.socketChannel);
        this.bufferedOut = new InterruptableOutputStream((OutputStream)new BufferedOutputStream((OutputStream)this.out));
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public void interrupt() {
        this.bufferedIn.interrupt();
        this.bufferedOut.interrupt();
    }

    @Override
    public void close() throws IOException {
        this.socketChannel.close();
    }

    @Override
    public void setTimeout(long value, TimeUnit timeUnit) {
        this.in.setTimeout((int)TimeUnit.MILLISECONDS.convert(value, timeUnit));
        this.out.setTimeout((int)TimeUnit.MILLISECONDS.convert(value, timeUnit));
        this.timeoutMillis = TimeUnit.MILLISECONDS.convert(value, timeUnit);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.bufferedIn;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.bufferedOut;
    }

    @Override
    public boolean isClosed() {
        boolean closed;
        boolean bl = closed = !this.socketChannel.isConnected();
        if (!closed) {
            try {
                this.in.isDataAvailable();
            }
            catch (IOException e) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                closed = true;
            }
        }
        return closed;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public SSLContext getSSLContext() {
        return null;
    }

    @Override
    public long getTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }
}

