/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.event;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.nifi.cdc.event.ColumnDefinition;
import org.apache.nifi.distributed.cache.client.exception.DeserializationException;
import org.apache.nifi.distributed.cache.client.exception.SerializationException;

public class TableInfo {
    static final String DB_TABLE_NAME_DELIMITER = "@!@";
    private String databaseName;
    private String tableName;
    private Long tableId;
    private List<ColumnDefinition> columns;

    public TableInfo(String databaseName, String tableName, Long tableId, List<ColumnDefinition> columns) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.tableId = tableId;
        this.columns = columns;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Long getTableId() {
        return this.tableId;
    }

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnDefinition> columns) {
        this.columns = columns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableInfo that = (TableInfo)o;
        return new EqualsBuilder().append((Object)this.databaseName, (Object)that.databaseName).append((Object)this.tableName, (Object)that.tableName).append((Object)this.tableId, (Object)that.tableId).append(this.columns, that.columns).isEquals();
    }

    public int hashCode() {
        int result = this.databaseName.hashCode();
        result = 31 * result + this.tableName.hashCode();
        result = 31 * result + this.tableId.hashCode();
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        return result;
    }

    public static class Deserializer
    implements org.apache.nifi.distributed.cache.client.Deserializer<TableInfo> {
        public TableInfo deserialize(byte[] input) throws DeserializationException, IOException {
            Long tableId;
            if (input == null || input.length == 0) {
                return null;
            }
            String inputString = new String(input);
            String[] tokens = inputString.split(TableInfo.DB_TABLE_NAME_DELIMITER);
            int numTokens = tokens.length;
            if (numTokens < 3) {
                throw new IOException("Could not deserialize TableInfo from the following value: " + inputString);
            }
            String dbName = tokens[0];
            String tableName = tokens[1];
            try {
                tableId = Long.parseLong(tokens[2]);
            }
            catch (NumberFormatException nfe) {
                throw new IOException("Illegal table ID: " + tokens[2]);
            }
            ArrayList<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
            for (int i = 0; i < numTokens - 3; i += 2) {
                try {
                    int columnTypeIndex = i + 4;
                    int columnNameIndex = i + 3;
                    if (columnTypeIndex >= numTokens) {
                        throw new IOException("No type detected for column: " + tokens[columnNameIndex]);
                    }
                    columnDefinitions.add(new ColumnDefinition(Integer.parseInt(tokens[columnTypeIndex]), tokens[columnNameIndex]));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("Illegal column type value for column " + (i / 2 + 1) + ": " + tokens[i + 4]);
                }
            }
            return new TableInfo(dbName, tableName, tableId, columnDefinitions);
        }
    }

    public static class Serializer
    implements org.apache.nifi.distributed.cache.client.Serializer<TableInfo> {
        public void serialize(TableInfo value, OutputStream output) throws SerializationException, IOException {
            StringBuilder sb = new StringBuilder(value.getDatabaseName());
            sb.append(TableInfo.DB_TABLE_NAME_DELIMITER);
            sb.append(value.getTableName());
            sb.append(TableInfo.DB_TABLE_NAME_DELIMITER);
            sb.append(value.getTableId());
            List<ColumnDefinition> columnDefinitions = value.getColumns();
            if (columnDefinitions != null && !columnDefinitions.isEmpty()) {
                sb.append(TableInfo.DB_TABLE_NAME_DELIMITER);
                sb.append(columnDefinitions.stream().map(col -> col.getName() + TableInfo.DB_TABLE_NAME_DELIMITER + col.getType()).collect(Collectors.joining(TableInfo.DB_TABLE_NAME_DELIMITER)));
            }
            output.write(sb.toString().getBytes());
        }
    }
}

