/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.documentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.DynamicRelationship;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.documentation.ExtensionDocumentationWriter;
import org.apache.nifi.documentation.ExtensionType;
import org.apache.nifi.documentation.ServiceAPI;
import org.apache.nifi.documentation.init.DocumentationControllerServiceInitializationContext;
import org.apache.nifi.documentation.init.DocumentationProcessorInitializationContext;
import org.apache.nifi.documentation.init.DocumentationReportingInitializationContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingTask;

public abstract class AbstractDocumentationWriter
implements ExtensionDocumentationWriter {
    @Override
    public void initialize(ConfigurableComponent component) {
        try {
            if (component instanceof Processor) {
                this.initialize((Processor)component);
            } else if (component instanceof ControllerService) {
                this.initialize((ControllerService)component);
            } else if (component instanceof ReportingTask) {
                this.initialize((ReportingTask)component);
            }
        }
        catch (InitializationException ie) {
            throw new RuntimeException("Failed to initialize " + component, ie);
        }
    }

    protected void initialize(Processor processor) {
        processor.initialize(new DocumentationProcessorInitializationContext());
    }

    protected void initialize(ControllerService service) throws InitializationException {
        service.initialize(new DocumentationControllerServiceInitializationContext());
    }

    protected void initialize(ReportingTask reportingTask) throws InitializationException {
        reportingTask.initialize(new DocumentationReportingInitializationContext());
    }

    @Override
    public final void write(ConfigurableComponent component) throws IOException {
        this.write(component, null, null);
    }

    @Override
    public final void write(ConfigurableComponent component, Collection<ServiceAPI> providedServices, Map<String, ServiceAPI> propertyServices) throws IOException {
        this.writeHeader(component);
        this.writeBody(component, propertyServices);
        if (providedServices != null && component instanceof ControllerService) {
            this.writeProvidedServices(providedServices);
        }
        this.writeFooter(component);
    }

    protected void writeBody(ConfigurableComponent component, Map<String, ServiceAPI> propertyServices) throws IOException {
        this.writeExtensionName(component.getClass().getName());
        this.writeExtensionType(this.getExtensionType(component));
        this.writeDeprecationNotice(component.getClass().getAnnotation(DeprecationNotice.class));
        this.writeDescription(this.getDescription(component));
        this.writeTags(this.getTags(component));
        this.writeProperties(component.getPropertyDescriptors(), propertyServices);
        this.writeDynamicProperties(this.getDynamicProperties(component));
        if (component instanceof Processor) {
            Processor processor = (Processor)component;
            this.writeRelationships(processor.getRelationships());
            this.writeDynamicRelationship(this.getDynamicRelationship(processor));
            this.writeReadsAttributes(this.getReadsAttributes(processor));
            this.writeWritesAttributes(this.getWritesAttributes(processor));
        }
        this.writeStatefulInfo(component.getClass().getAnnotation(Stateful.class));
        this.writeRestrictedInfo(component.getClass().getAnnotation(Restricted.class));
        this.writeInputRequirementInfo(this.getInputRequirement(component));
        this.writeSystemResourceConsiderationInfo(this.getSystemResourceConsiderations(component));
        this.writeSeeAlso(component.getClass().getAnnotation(SeeAlso.class));
    }

    protected String getDescription(ConfigurableComponent component) {
        CapabilityDescription capabilityDescription = component.getClass().getAnnotation(CapabilityDescription.class);
        if (capabilityDescription == null) {
            return null;
        }
        return capabilityDescription.value();
    }

    protected List<String> getTags(ConfigurableComponent component) {
        Tags tags = component.getClass().getAnnotation(Tags.class);
        if (tags == null) {
            return Collections.emptyList();
        }
        String[] tagValues = tags.value();
        return tagValues == null ? Collections.emptyList() : Arrays.asList(tagValues);
    }

    protected List<DynamicProperty> getDynamicProperties(ConfigurableComponent configurableComponent) {
        DynamicProperty dynProp;
        ArrayList<DynamicProperty> dynamicProperties = new ArrayList<DynamicProperty>();
        DynamicProperties dynProps = configurableComponent.getClass().getAnnotation(DynamicProperties.class);
        if (dynProps != null) {
            Collections.addAll(dynamicProperties, dynProps.value());
        }
        if ((dynProp = configurableComponent.getClass().getAnnotation(DynamicProperty.class)) != null) {
            dynamicProperties.add(dynProp);
        }
        return dynamicProperties;
    }

    private DynamicRelationship getDynamicRelationship(Processor processor) {
        return processor.getClass().getAnnotation(DynamicRelationship.class);
    }

    private List<ReadsAttribute> getReadsAttributes(Processor processor) {
        ReadsAttribute readsAttribute;
        ArrayList<ReadsAttribute> attributes = new ArrayList<ReadsAttribute>();
        ReadsAttributes readsAttributes = processor.getClass().getAnnotation(ReadsAttributes.class);
        if (readsAttributes != null) {
            Collections.addAll(attributes, readsAttributes.value());
        }
        if ((readsAttribute = processor.getClass().getAnnotation(ReadsAttribute.class)) != null) {
            attributes.add(readsAttribute);
        }
        return attributes;
    }

    private List<WritesAttribute> getWritesAttributes(Processor processor) {
        WritesAttribute writeAttribute;
        ArrayList<WritesAttribute> attributes = new ArrayList<WritesAttribute>();
        WritesAttributes writesAttributes = processor.getClass().getAnnotation(WritesAttributes.class);
        if (writesAttributes != null) {
            Collections.addAll(attributes, writesAttributes.value());
        }
        if ((writeAttribute = processor.getClass().getAnnotation(WritesAttribute.class)) != null) {
            attributes.add(writeAttribute);
        }
        return attributes;
    }

    private InputRequirement.Requirement getInputRequirement(ConfigurableComponent component) {
        InputRequirement annotation = component.getClass().getAnnotation(InputRequirement.class);
        return annotation == null ? null : annotation.value();
    }

    private List<SystemResourceConsideration> getSystemResourceConsiderations(ConfigurableComponent component) {
        SystemResourceConsideration[] systemResourceConsiderations = (SystemResourceConsideration[])component.getClass().getAnnotationsByType(SystemResourceConsideration.class);
        if (systemResourceConsiderations == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(systemResourceConsiderations);
    }

    protected ExtensionType getExtensionType(ConfigurableComponent component) {
        if (component instanceof Processor) {
            return ExtensionType.PROCESSOR;
        }
        if (component instanceof ControllerService) {
            return ExtensionType.CONTROLLER_SERVICE;
        }
        if (component instanceof ReportingTask) {
            return ExtensionType.REPORTING_TASK;
        }
        throw new AssertionError((Object)("Encountered unknown Configurable Component Type for " + component));
    }

    protected abstract void writeHeader(ConfigurableComponent var1) throws IOException;

    protected abstract void writeExtensionName(String var1) throws IOException;

    protected abstract void writeExtensionType(ExtensionType var1) throws IOException;

    protected abstract void writeDeprecationNotice(DeprecationNotice var1) throws IOException;

    protected abstract void writeDescription(String var1) throws IOException;

    protected abstract void writeTags(List<String> var1) throws IOException;

    protected abstract void writeProperties(List<PropertyDescriptor> var1, Map<String, ServiceAPI> var2) throws IOException;

    protected abstract void writeDynamicProperties(List<DynamicProperty> var1) throws IOException;

    protected abstract void writeStatefulInfo(Stateful var1) throws IOException;

    protected abstract void writeRestrictedInfo(Restricted var1) throws IOException;

    protected abstract void writeInputRequirementInfo(InputRequirement.Requirement var1) throws IOException;

    protected abstract void writeSystemResourceConsiderationInfo(List<SystemResourceConsideration> var1) throws IOException;

    protected abstract void writeSeeAlso(SeeAlso var1) throws IOException;

    protected abstract void writeRelationships(Set<Relationship> var1) throws IOException;

    protected abstract void writeDynamicRelationship(DynamicRelationship var1) throws IOException;

    protected abstract void writeReadsAttributes(List<ReadsAttribute> var1) throws IOException;

    protected abstract void writeWritesAttributes(List<WritesAttribute> var1) throws IOException;

    protected abstract void writeProvidedServices(Collection<ServiceAPI> var1) throws IOException;

    protected abstract void writeFooter(ConfigurableComponent var1) throws IOException;
}

