/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service.operation;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.nifi.c2.client.service.C2HeartbeatFactory;
import org.apache.nifi.c2.client.service.model.RuntimeInfoWrapper;
import org.apache.nifi.c2.client.service.operation.C2OperationHandler;
import org.apache.nifi.c2.client.service.operation.OperandPropertiesProvider;
import org.apache.nifi.c2.protocol.api.AgentInfo;
import org.apache.nifi.c2.protocol.api.C2Heartbeat;
import org.apache.nifi.c2.protocol.api.C2Operation;
import org.apache.nifi.c2.protocol.api.C2OperationAck;
import org.apache.nifi.c2.protocol.api.C2OperationState;
import org.apache.nifi.c2.protocol.api.OperandType;
import org.apache.nifi.c2.protocol.api.OperationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescribeManifestOperationHandler
implements C2OperationHandler {
    private static final String ERROR_MESSAGE = "Failed to execute manifest describe operation.";
    private final C2HeartbeatFactory heartbeatFactory;
    private final Supplier<RuntimeInfoWrapper> runtimeInfoSupplier;
    private final OperandPropertiesProvider operandPropertiesProvider;
    private static final Logger LOGGER = LoggerFactory.getLogger(DescribeManifestOperationHandler.class);

    public DescribeManifestOperationHandler(C2HeartbeatFactory heartbeatFactory, Supplier<RuntimeInfoWrapper> runtimeInfoSupplier, OperandPropertiesProvider operandPropertiesProvider) {
        this.heartbeatFactory = heartbeatFactory;
        this.runtimeInfoSupplier = runtimeInfoSupplier;
        this.operandPropertiesProvider = operandPropertiesProvider;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.DESCRIBE;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.MANIFEST;
    }

    @Override
    public C2OperationAck handle(C2Operation operation) {
        C2OperationAck c2OperationAck;
        String operationId = Optional.ofNullable(operation.getIdentifier()).orElse("");
        try {
            RuntimeInfoWrapper runtimeInfoWrapper = this.runtimeInfoSupplier.get();
            C2Heartbeat heartbeat = this.heartbeatFactory.create(runtimeInfoWrapper);
            c2OperationAck = this.operationAck(operationId, this.operationState(C2OperationState.OperationState.FULLY_APPLIED, ""));
            c2OperationAck.setAgentInfo(this.agentInfo(heartbeat, runtimeInfoWrapper));
            c2OperationAck.setDeviceInfo(heartbeat.getDeviceInfo());
            c2OperationAck.setFlowInfo(heartbeat.getFlowInfo());
            c2OperationAck.setResourceInfo(heartbeat.getResourceInfo());
        }
        catch (Exception e) {
            LOGGER.error(ERROR_MESSAGE, (Throwable)e);
            c2OperationAck = this.operationAck(operationId, this.operationState(C2OperationState.OperationState.NOT_APPLIED, ERROR_MESSAGE, e));
        }
        return c2OperationAck;
    }

    private AgentInfo agentInfo(C2Heartbeat heartbeat, RuntimeInfoWrapper runtimeInfoWrapper) {
        AgentInfo agentInfo = heartbeat.getAgentInfo();
        agentInfo.setAgentManifest(runtimeInfoWrapper.getManifest());
        return agentInfo;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.operandPropertiesProvider.getProperties();
    }
}

