/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service.operation;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.c2.protocol.api.C2Operation;
import org.apache.nifi.c2.protocol.api.C2OperationAck;
import org.apache.nifi.c2.protocol.api.C2OperationState;
import org.apache.nifi.c2.protocol.api.FailureCause;
import org.apache.nifi.c2.protocol.api.OperandType;
import org.apache.nifi.c2.protocol.api.OperationType;
import org.apache.nifi.c2.serializer.C2Serializer;
import org.apache.nifi.minifi.validator.ValidationException;

public interface C2OperationHandler {
    public OperationType getOperationType();

    public OperandType getOperandType();

    public Map<String, Object> getProperties();

    default public boolean requiresRestart() {
        return false;
    }

    public C2OperationAck handle(C2Operation var1);

    default public C2OperationState operationState(C2OperationState.OperationState operationState, String details, Exception e) {
        C2OperationState state = new C2OperationState();
        state.setState(operationState);
        state.setDetails(details);
        Optional.ofNullable(e).map(this::toFailureCause).ifPresent(arg_0 -> ((C2OperationState)state).setFailureCause(arg_0));
        return state;
    }

    private FailureCause toFailureCause(Exception exception) {
        FailureCause failureCause = new FailureCause();
        failureCause.setExceptionMessage(exception.getMessage());
        LinkedList<String> causeList = new LinkedList<String>();
        this.populateCausedChain(Optional.ofNullable(exception.getCause()), causeList);
        failureCause.setCausedByMessages(causeList);
        if (exception instanceof ValidationException) {
            ValidationException validationException = (ValidationException)exception;
            failureCause.setValidationResults(validationException.getValidationResults());
        }
        return failureCause;
    }

    private List<String> populateCausedChain(Optional<Throwable> cause, List<String> causeList) {
        cause.ifPresent(c -> {
            causeList.add(c.getMessage());
            this.populateCausedChain(cause.map(Throwable::getCause), causeList);
        });
        return causeList;
    }

    default public C2OperationState operationState(C2OperationState.OperationState operationState, String details) {
        return this.operationState(operationState, details, null);
    }

    default public C2OperationAck operationAck(String operationId, C2OperationState operationState) {
        C2OperationAck operationAck = new C2OperationAck();
        operationAck.setOperationState(operationState);
        operationAck.setOperationId(operationId);
        return operationAck;
    }

    default public Optional<String> getOperationArg(C2Operation operation, String argument) {
        return Optional.ofNullable(operation.getArgs()).map(args -> args.get(argument)).map(arg -> {
            String s;
            return arg instanceof String ? (s = (String)arg) : null;
        });
    }

    default public <T> T getOperationArg(C2Operation operation, String argument, TypeReference<T> type, C2Serializer serializer) {
        return (T)Optional.ofNullable(operation.getArgs()).map(args -> args.get(argument)).flatMap(arg -> serializer.convert(arg, type)).orElseThrow(() -> new IllegalArgumentException("Failed to parse argument " + argument + " of operation " + String.valueOf(operation)));
    }
}

