/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.http.url;

import java.util.Optional;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.nifi.c2.client.http.url.C2UrlProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyAwareC2UrlProvider
implements C2UrlProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyAwareC2UrlProvider.class);
    private static final String SLASH = "/";
    private final HttpUrl c2RestPathBase;
    private final String c2RestPathHeartbeat;
    private final String c2RestPathAcknowledge;

    ProxyAwareC2UrlProvider(String c2RestPathBase, String c2RestPathHeartbeat, String c2RestPathAcknowledge) {
        this.c2RestPathBase = Optional.ofNullable(c2RestPathBase).filter(StringUtils::isNotBlank).map(apiBase -> Strings.CS.appendIfMissing(apiBase, (CharSequence)SLASH, new CharSequence[0])).map(HttpUrl::parse).orElseThrow(() -> new IllegalArgumentException("Parameter c2RestPathBase should not be null or empty and should be a valid URL"));
        this.c2RestPathHeartbeat = this.toAbsoluteUrl(c2RestPathHeartbeat).orElseThrow(() -> new IllegalArgumentException("Unable to convert c2RestPathHeartbeat to absolute url. Please check C2 configuration"));
        this.c2RestPathAcknowledge = this.toAbsoluteUrl(c2RestPathAcknowledge).orElseThrow(() -> new IllegalArgumentException("Unable to convert c2RestPathAcknowledge to absolute url. Please check C2 configuration"));
    }

    @Override
    public String getHeartbeatUrl() {
        return this.c2RestPathHeartbeat;
    }

    @Override
    public String getAcknowledgeUrl() {
        return this.c2RestPathAcknowledge;
    }

    @Override
    public String getCallbackUrl(String absoluteUrl, String relativeUrl) {
        return (String)Optional.ofNullable(relativeUrl).map(this::toAbsoluteUrl).filter(Optional::isPresent).orElseGet(() -> Optional.ofNullable(absoluteUrl).filter(StringUtils::isNotBlank)).orElseThrow(() -> new IllegalArgumentException("Unable to return non empty c2 url."));
    }

    private Optional<String> toAbsoluteUrl(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            LOG.error("Unable to convert to absolute url, provided path was null or empty");
            return Optional.empty();
        }
        try {
            return Optional.of(this.c2RestPathBase.resolve(StringUtils.stripStart((String)path, (String)SLASH)).toString());
        }
        catch (Exception e) {
            LOG.error("Unable to convert restBase={} and restPath={} to absolute url", new Object[]{this.c2RestPathBase, path, e});
            return Optional.empty();
        }
    }
}

