/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.buildtools.maven2.plugin.javascript.uixtools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.uixtools.Detokenizer;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.uixtools.FileProcessor;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.uixtools.Filter1;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.uixtools.Filter2;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.uixtools.Token;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.uixtools.TokenReader;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.uixtools.Tokenizer;

public class Reducer
extends FileProcessor {
    private final boolean _STRIP_WHITESPACE_COMMENTS;
    private final boolean _RENAME_LOCAL_VARIABLES;

    public Reducer(boolean whitespaceComments, boolean localVars) {
        super(".js", false);
        this._STRIP_WHITESPACE_COMMENTS = whitespaceComments;
        this._RENAME_LOCAL_VARIABLES = localVars;
    }

    public Reducer() {
        this(true, true);
    }

    public void process(BufferedReader in, PrintWriter out) throws IOException, InterruptedException {
        Token tok;
        TokenReader tr = new Tokenizer(in);
        if (this._STRIP_WHITESPACE_COMMENTS) {
            tr = new Filter1(tr);
        }
        if (this._RENAME_LOCAL_VARIABLES) {
            tr = new Filter2(tr);
        }
        Detokenizer detok = new Detokenizer(out);
        while ((tok = tr.read()) != null) {
            detok.write(tok);
        }
    }

    protected void processFile(File in, File out) throws IOException, InterruptedException {
        BufferedReader reader = new BufferedReader(new FileReader(in));
        PrintWriter writer = new PrintWriter(new FileWriter(out));
        this.process(reader, writer);
        writer.close();
        reader.close();
    }

    private static void _help() {
        String s = "Reduces JavaScript source code\nUsage:\njava oracle.uix.tools.uix22.javascript.Reducer [-norename] [-whitespace] [-help] input output \n input/output can be either files or directories.\n Directories will be processed recursively.\n Only files with names that end with .js will be processed.\n -norename prevents renaming local variables to short ones\n -whitespace prevents removing comments and extra whitespace\n -help prints this message.";
        System.out.println(s);
    }

    public static void main(String[] args) {
        boolean rename = true;
        boolean space = true;
        int sz = args.length - 2;
        if (sz < 0) {
            Reducer._help();
            return;
        }
        for (int i = 0; i < sz; ++i) {
            String s = args[i];
            if (s.equals("-help")) {
                Reducer._help();
                continue;
            }
            if (s.equals("-norename")) {
                rename = false;
                continue;
            }
            if (s.equals("-whitespace")) {
                space = false;
                continue;
            }
            System.out.println("Unknown option:" + s);
            Reducer._help();
            return;
        }
        File in = new File(args[sz]);
        File out = new File(args[sz + 1]);
        Reducer reducer = new Reducer(space, rename);
        reducer.process(in, out);
    }
}

