/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.buildtools.maven2.plugin.javascript.jmt.compress;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.jmt.compress.CompressionException;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.jmt.compress.JSCompressor;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringOutputStream;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.ShellContextFactory;

public class ShrinksafeCompressor
implements JSCompressor {
    public void compress(final File input, File compressed, int level, int language) throws CompressionException {
        PrintStream o = System.out;
        System.setOut(new PrintStream((OutputStream)new StringOutputStream()));
        OutputStream out = null;
        try {
            String[] args = new String[]{"-c", "-o", compressed.getAbsolutePath()};
            Main.processOptions((String[])args);
            ToolErrorReporter errorReporter = new ToolErrorReporter(false, System.err);
            errorReporter.setIsReportingWarnings(false);
            ShellContextFactory shellContextFactory = new ShellContextFactory();
            shellContextFactory.setLanguageVersion(language);
            shellContextFactory.setOptimizationLevel(level);
            shellContextFactory.setErrorReporter((ErrorReporter)errorReporter);
            shellContextFactory.setStrictMode(true);
            final Global scope = new Global();
            scope.init((ContextFactory)shellContextFactory);
            shellContextFactory.call(new ContextAction(){

                public Object run(Context context) {
                    Object[] args = new Object[1];
                    scope.defineProperty("arguments", (Object)args, 2);
                    Main.processFile((Context)context, (Scriptable)scope, (String)input.getAbsolutePath());
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new CompressionException("Failed to create compressed file", e, input);
        }
        finally {
            System.setOut(o);
            IOUtil.close(out);
        }
    }
}

