/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.statemachine.event;

import org.apache.mina.statemachine.context.StateContext;

public class Event {
    public static final String WILDCARD_EVENT_ID = "*";
    private final Object id;
    private final StateContext context;
    private final Object[] arguments;

    public Event(Object id, StateContext context) {
        this(id, context, new Object[0]);
    }

    public Event(Object id, StateContext context, Object[] arguments) {
        if (id == null) {
            throw new IllegalArgumentException("id");
        }
        if (context == null) {
            throw new IllegalArgumentException("context");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("arguments");
        }
        this.id = id;
        this.context = context;
        this.arguments = arguments;
    }

    public StateContext getContext() {
        return this.context;
    }

    public Object getId() {
        return this.id;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Event[");
        sb.append("id=").append(this.id);
        sb.append(",context=").append(this.context);
        sb.append(",arguments=");
        if (this.arguments != null) {
            sb.append('{');
            boolean isFirst = true;
            for (Object argument : this.arguments) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(argument);
            }
            sb.append('}');
        } else {
            sb.append("null");
        }
        sb.append("]");
        return sb.toString();
    }
}

