/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.statemachine.context;

import org.apache.mina.statemachine.context.StateContext;
import org.apache.mina.statemachine.context.StateContextFactory;
import org.apache.mina.statemachine.context.StateContextLookup;

public abstract class AbstractStateContextLookup
implements StateContextLookup {
    private final StateContextFactory contextFactory;

    public AbstractStateContextLookup(StateContextFactory contextFactory) {
        if (contextFactory == null) {
            throw new IllegalArgumentException("contextFactory");
        }
        this.contextFactory = contextFactory;
    }

    @Override
    public StateContext lookup(Object[] eventArgs) {
        for (int i = 0; i < eventArgs.length; ++i) {
            if (!this.supports(eventArgs[i].getClass())) continue;
            StateContext sc = this.lookup(eventArgs[i]);
            if (sc == null) {
                sc = this.contextFactory.create();
                this.store(eventArgs[i], sc);
            }
            return sc;
        }
        return null;
    }

    protected abstract StateContext lookup(Object var1);

    protected abstract void store(Object var1, StateContext var2);

    protected abstract boolean supports(Class<?> var1);
}

