/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.statemachine;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.mina.statemachine.StateMachine;
import org.apache.mina.statemachine.context.SingletonStateContextLookup;
import org.apache.mina.statemachine.context.StateContext;
import org.apache.mina.statemachine.context.StateContextLookup;
import org.apache.mina.statemachine.event.DefaultEventFactory;
import org.apache.mina.statemachine.event.Event;
import org.apache.mina.statemachine.event.EventArgumentsInterceptor;
import org.apache.mina.statemachine.event.EventFactory;
import org.apache.mina.statemachine.event.UnhandledEventException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateMachineProxyBuilder {
    private static final Logger log = LoggerFactory.getLogger(StateMachineProxyBuilder.class);
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    private StateContextLookup contextLookup = new SingletonStateContextLookup();
    private EventFactory eventFactory = new DefaultEventFactory();
    private EventArgumentsInterceptor interceptor = null;
    private boolean ignoreUnhandledEvents = false;
    private boolean ignoreStateContextLookupFailure = false;
    private String name = null;
    private ClassLoader defaultCl = null;

    public StateMachineProxyBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public StateMachineProxyBuilder setStateContextLookup(StateContextLookup contextLookup) {
        this.contextLookup = contextLookup;
        return this;
    }

    public StateMachineProxyBuilder setEventFactory(EventFactory eventFactory) {
        this.eventFactory = eventFactory;
        return this;
    }

    public StateMachineProxyBuilder setEventArgumentsInterceptor(EventArgumentsInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public StateMachineProxyBuilder setIgnoreUnhandledEvents(boolean b) {
        this.ignoreUnhandledEvents = b;
        return this;
    }

    public StateMachineProxyBuilder setIgnoreStateContextLookupFailure(boolean b) {
        this.ignoreStateContextLookupFailure = b;
        return this;
    }

    public StateMachineProxyBuilder setClassLoader(ClassLoader cl) {
        this.defaultCl = cl;
        return this;
    }

    public <T> T create(Class<T> iface, StateMachine sm) {
        return (T)this.create(new Class[]{iface}, sm);
    }

    public Object create(Class<?>[] ifaces, StateMachine sm) {
        ClassLoader cl = this.defaultCl;
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        MethodInvocationHandler handler = new MethodInvocationHandler(sm, this.contextLookup, this.interceptor, this.eventFactory, this.ignoreUnhandledEvents, this.ignoreStateContextLookupFailure, this.name);
        return Proxy.newProxyInstance(cl, ifaces, (InvocationHandler)handler);
    }

    private static class MethodInvocationHandler
    implements InvocationHandler {
        private final StateMachine sm;
        private final StateContextLookup contextLookup;
        private final EventArgumentsInterceptor interceptor;
        private final EventFactory eventFactory;
        private final boolean ignoreUnhandledEvents;
        private final boolean ignoreStateContextLookupFailure;
        private final String name;

        public MethodInvocationHandler(StateMachine sm, StateContextLookup contextLookup, EventArgumentsInterceptor interceptor, EventFactory eventFactory, boolean ignoreUnhandledEvents, boolean ignoreStateContextLookupFailure, String name) {
            this.contextLookup = contextLookup;
            this.sm = sm;
            this.interceptor = interceptor;
            this.eventFactory = eventFactory;
            this.ignoreUnhandledEvents = ignoreUnhandledEvents;
            this.ignoreStateContextLookupFailure = ignoreStateContextLookupFailure;
            this.name = name;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            block9: {
                StateContext context;
                if ("hashCode".equals(method.getName()) && args == null) {
                    return System.identityHashCode(proxy);
                }
                if ("equals".equals(method.getName()) && args.length == 1) {
                    return proxy == args[0];
                }
                if ("toString".equals(method.getName()) && args == null) {
                    return (this.name != null ? this.name : proxy.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(proxy));
                }
                if (log.isDebugEnabled()) {
                    log.debug("Method invoked: " + method);
                }
                Object[] objectArray = args = args == null ? EMPTY_ARGUMENTS : args;
                if (this.interceptor != null) {
                    args = this.interceptor.modify(args);
                }
                if ((context = this.contextLookup.lookup(args)) == null) {
                    if (this.ignoreStateContextLookupFailure) {
                        return null;
                    }
                    throw new IllegalStateException("Cannot determine state context for method invocation: " + method);
                }
                Event event = this.eventFactory.create(context, method, args);
                try {
                    this.sm.handle(event);
                }
                catch (UnhandledEventException uee) {
                    if (this.ignoreUnhandledEvents) break block9;
                    throw uee;
                }
            }
            return null;
        }
    }
}

