/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.statemachine.transition;

import org.apache.mina.statemachine.State;
import org.apache.mina.statemachine.event.Event;
import org.apache.mina.statemachine.transition.Transition;

public abstract class AbstractTransition
implements Transition {
    private final Object eventId;
    private final State nextState;

    public AbstractTransition(Object eventId) {
        this(eventId, null);
    }

    public AbstractTransition(Object eventId, State nextState) {
        this.eventId = eventId;
        this.nextState = nextState;
    }

    @Override
    public State getNextState() {
        return this.nextState;
    }

    @Override
    public boolean execute(Event event) {
        if (!this.eventId.equals("*") && !this.eventId.equals(event.getId())) {
            return false;
        }
        return this.doExecute(event);
    }

    protected abstract boolean doExecute(Event var1);

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTransition)) {
            return false;
        }
        AbstractTransition that = (AbstractTransition)o;
        if (this.eventId != null ? !this.eventId.equals(that.eventId) : that.eventId != null) {
            return false;
        }
        if (this.nextState != null) {
            return this.nextState.equals(that.nextState);
        }
        return that.nextState == null;
    }

    public int hashCode() {
        int h = 17;
        if (this.eventId != null) {
            h = h * 37 + this.eventId.hashCode();
        }
        if (this.nextState != null) {
            h = h * 17 + this.nextState.hashCode();
        }
        return h;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("eventId=").append(this.eventId);
        sb.append(",nextState=").append(this.nextState);
        return sb.toString();
    }
}

