/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.statemachine;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.mina.statemachine.StateMachine;
import org.apache.mina.statemachine.StateMachineCreationException;
import org.apache.mina.statemachine.annotation.OnEntry;
import org.apache.mina.statemachine.annotation.OnExit;
import org.apache.mina.statemachine.annotation.State;
import org.apache.mina.statemachine.annotation.TransitionAnnotation;
import org.apache.mina.statemachine.transition.MethodSelfTransition;
import org.apache.mina.statemachine.transition.MethodTransition;

public class StateMachineFactory {
    private final Class<? extends Annotation> transitionAnnotation;
    private final Class<? extends Annotation> transitionsAnnotation;
    private final Class<? extends Annotation> entrySelfTransitionsAnnotation;
    private final Class<? extends Annotation> exitSelfTransitionsAnnotation;

    protected StateMachineFactory(Class<? extends Annotation> transitionAnnotation, Class<? extends Annotation> transitionsAnnotation, Class<? extends Annotation> entrySelfTransitionsAnnotation, Class<? extends Annotation> exitSelfTransitionsAnnotation) {
        this.transitionAnnotation = transitionAnnotation;
        this.transitionsAnnotation = transitionsAnnotation;
        this.entrySelfTransitionsAnnotation = entrySelfTransitionsAnnotation;
        this.exitSelfTransitionsAnnotation = exitSelfTransitionsAnnotation;
    }

    public static StateMachineFactory getInstance(Class<? extends Annotation> transitionAnnotation) {
        TransitionAnnotation a = transitionAnnotation.getAnnotation(TransitionAnnotation.class);
        if (a == null) {
            throw new IllegalArgumentException("The annotation class " + transitionAnnotation + " has not been annotated with the " + TransitionAnnotation.class.getName() + " annotation");
        }
        return new StateMachineFactory(transitionAnnotation, a.value(), OnEntry.class, OnExit.class);
    }

    public StateMachine create(Object handler) {
        return this.create(handler, new Object[0]);
    }

    public StateMachine create(String start, Object handler) {
        return this.create(start, handler, new Object[0]);
    }

    public StateMachine create(Object handler, Object ... handlers) {
        return this.create("start", handler, handlers);
    }

    public StateMachine create(String start, Object handler, Object ... handlers) {
        HashMap<String, org.apache.mina.statemachine.State> states = new HashMap<String, org.apache.mina.statemachine.State>();
        ArrayList<Object> handlersList = new ArrayList<Object>(1 + handlers.length);
        handlersList.add(handler);
        handlersList.addAll(Arrays.asList(handlers));
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Object e : handlersList) {
            fields.addAll(StateMachineFactory.getFields(e instanceof Class ? (Class<?>)e : e.getClass()));
        }
        for (org.apache.mina.statemachine.State state : StateMachineFactory.createStates(fields)) {
            states.put(state.getId(), state);
        }
        if (!states.containsKey(start)) {
            throw new StateMachineCreationException("Start state '" + start + "' not found.");
        }
        StateMachineFactory.setupTransitions(this.transitionAnnotation, this.transitionsAnnotation, this.entrySelfTransitionsAnnotation, this.exitSelfTransitionsAnnotation, states, handlersList);
        return new StateMachine(states.values(), start);
    }

    private static void setupTransitions(Class<? extends Annotation> transitionAnnotation, Class<? extends Annotation> transitionsAnnotation, Class<? extends Annotation> onEntrySelfTransitionAnnotation, Class<? extends Annotation> onExitSelfTransitionAnnotation, Map<String, org.apache.mina.statemachine.State> states, List<Object> handlers) {
        for (Object handler : handlers) {
            StateMachineFactory.setupTransitions(transitionAnnotation, transitionsAnnotation, onEntrySelfTransitionAnnotation, onExitSelfTransitionAnnotation, states, handler);
        }
    }

    private static void setupSelfTransitions(Method m, Class<? extends Annotation> onEntrySelfTransitionAnnotation, Class<? extends Annotation> onExitSelfTransitionAnnotation, Map<String, org.apache.mina.statemachine.State> states, Object handler) {
        org.apache.mina.statemachine.State state;
        if (m.isAnnotationPresent(OnEntry.class)) {
            OnEntry onEntryAnnotation = (OnEntry)m.getAnnotation(onEntrySelfTransitionAnnotation);
            state = states.get(onEntryAnnotation.value());
            if (state == null) {
                throw new StateMachineCreationException("Error encountered when processing onEntry annotation in method " + m + ". state " + onEntryAnnotation.value() + " not Found.");
            }
            state.addOnEntrySelfTransaction(new MethodSelfTransition(m, handler));
        }
        if (m.isAnnotationPresent(OnExit.class)) {
            OnExit onExitAnnotation = (OnExit)m.getAnnotation(onExitSelfTransitionAnnotation);
            state = states.get(onExitAnnotation.value());
            if (state == null) {
                throw new StateMachineCreationException("Error encountered when processing onExit annotation in method " + m + ". state " + onExitAnnotation.value() + " not Found.");
            }
            state.addOnExitSelfTransaction(new MethodSelfTransition(m, handler));
        }
    }

    private static void setupTransitions(Class<? extends Annotation> transitionAnnotation, Class<? extends Annotation> transitionsAnnotation, Class<? extends Annotation> onEntrySelfTransitionAnnotation, Class<? extends Annotation> onExitSelfTransitionAnnotation, Map<String, org.apache.mina.statemachine.State> states, Object handler) {
        Method[] methods = handler.getClass().getDeclaredMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return m1.toString().compareTo(m2.toString());
            }
        });
        for (Method m : methods) {
            StateMachineFactory.setupSelfTransitions(m, onEntrySelfTransitionAnnotation, onExitSelfTransitionAnnotation, states, handler);
            ArrayList<TransitionWrapper> transitionAnnotations = new ArrayList<TransitionWrapper>();
            if (m.isAnnotationPresent(transitionAnnotation)) {
                transitionAnnotations.add(new TransitionWrapper(transitionAnnotation, m.getAnnotation(transitionAnnotation)));
            }
            if (m.isAnnotationPresent(transitionsAnnotation)) {
                transitionAnnotations.addAll(Arrays.asList(new TransitionsWrapper(transitionAnnotation, transitionsAnnotation, m.getAnnotation(transitionsAnnotation)).value()));
            }
            if (transitionAnnotations.isEmpty()) continue;
            for (TransitionWrapper annotation : transitionAnnotations) {
                Object[] eventIds = annotation.on();
                if (eventIds.length == 0) {
                    throw new StateMachineCreationException("Error encountered when processing method " + m + ". No event ids specified.");
                }
                if (annotation.in().length == 0) {
                    throw new StateMachineCreationException("Error encountered when processing method " + m + ". No states specified.");
                }
                org.apache.mina.statemachine.State next = null;
                if (!annotation.next().equals("__self__") && (next = states.get(annotation.next())) == null) {
                    throw new StateMachineCreationException("Error encountered when processing method " + m + ". Unknown next state: " + annotation.next() + ".");
                }
                for (Object event : eventIds) {
                    if (event == null) {
                        event = "*";
                    }
                    if (!(event instanceof String)) {
                        event = event.toString();
                    }
                    for (String in : annotation.in()) {
                        org.apache.mina.statemachine.State state = states.get(in);
                        if (state == null) {
                            throw new StateMachineCreationException("Error encountered when processing method " + m + ". Unknown state: " + in + ".");
                        }
                        state.addTransition(new MethodTransition(event, next, m, handler), annotation.weight());
                    }
                }
            }
        }
    }

    static List<Field> getFields(Class<?> clazz) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(State.class)) continue;
            if ((f.getModifiers() & 8) == 0 || (f.getModifiers() & 0x10) == 0 || !f.getType().equals(String.class)) {
                throw new StateMachineCreationException("Error encountered when processing field " + f + ". Only static final " + "String fields can be used with the @State " + "annotation.");
            }
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            fields.add(f);
        }
        return fields;
    }

    static org.apache.mina.statemachine.State[] createStates(List<Field> fields) {
        LinkedHashMap<String, org.apache.mina.statemachine.State> states = new LinkedHashMap<String, org.apache.mina.statemachine.State>();
        while (!fields.isEmpty()) {
            int size = fields.size();
            int numStates = states.size();
            for (int i = 0; i < size; ++i) {
                Field f = fields.remove(0);
                String value = null;
                try {
                    value = (String)f.get(null);
                }
                catch (IllegalAccessException iae) {
                    throw new StateMachineCreationException("Error encountered when processing field " + f + ".", iae);
                }
                State stateAnnotation = f.getAnnotation(State.class);
                if (stateAnnotation.value().equals("__root__")) {
                    states.put(value, new org.apache.mina.statemachine.State(value));
                    continue;
                }
                if (states.containsKey(stateAnnotation.value())) {
                    states.put(value, new org.apache.mina.statemachine.State(value, (org.apache.mina.statemachine.State)states.get(stateAnnotation.value())));
                    continue;
                }
                fields.add(f);
            }
            if (states.size() != numStates) continue;
            throw new StateMachineCreationException("Error encountered while creating FSM. The following fields specify non-existing parent states: " + fields);
        }
        return states.values().toArray(new org.apache.mina.statemachine.State[0]);
    }

    private static class TransitionsWrapper {
        private final Class<? extends Annotation> transitionsclazz;
        private final Class<? extends Annotation> transitionClazz;
        private final Annotation annotation;

        public TransitionsWrapper(Class<? extends Annotation> transitionClazz, Class<? extends Annotation> transitionsclazz, Annotation annotation) {
            this.transitionClazz = transitionClazz;
            this.transitionsclazz = transitionsclazz;
            this.annotation = annotation;
        }

        TransitionWrapper[] value() {
            Annotation[] annos = this.getParameter("value", Annotation[].class);
            TransitionWrapper[] wrappers = new TransitionWrapper[annos.length];
            for (int i = 0; i < annos.length; ++i) {
                wrappers[i] = new TransitionWrapper(this.transitionClazz, annos[i]);
            }
            return wrappers;
        }

        private <T> T getParameter(String name, Class<T> returnType) {
            try {
                Method m = this.transitionsclazz.getMethod(name, new Class[0]);
                if (!returnType.isAssignableFrom(m.getReturnType())) {
                    throw new NoSuchMethodException();
                }
                return (T)m.invoke((Object)this.annotation, new Object[0]);
            }
            catch (Exception e) {
                throw new StateMachineCreationException("Could not get parameter '" + name + "' from Transitions annotation " + this.transitionsclazz);
            }
        }
    }

    private static class TransitionWrapper {
        private final Class<? extends Annotation> transitionClazz;
        private final Annotation annotation;

        public TransitionWrapper(Class<? extends Annotation> transitionClazz, Annotation annotation) {
            this.transitionClazz = transitionClazz;
            this.annotation = annotation;
        }

        Object[] on() {
            return this.getParameter("on", Object[].class);
        }

        String[] in() {
            return this.getParameter("in", String[].class);
        }

        String next() {
            return this.getParameter("next", String.class);
        }

        int weight() {
            return this.getParameter("weight", Integer.TYPE);
        }

        private <T> T getParameter(String name, Class<T> returnType) {
            try {
                Method m = this.transitionClazz.getMethod(name, new Class[0]);
                if (!returnType.isAssignableFrom(m.getReturnType())) {
                    throw new NoSuchMethodException();
                }
                return (T)m.invoke((Object)this.annotation, new Object[0]);
            }
            catch (Exception e) {
                throw new StateMachineCreationException("Could not get parameter '" + name + "' from Transition annotation " + this.transitionClazz);
            }
        }
    }
}

