/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.chat.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.example.chat.client.ChatClientSupport;
import org.apache.mina.example.chat.client.ConnectDialog;
import org.apache.mina.example.chat.client.SwingChatClientHandler;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class SwingChatClient
extends JFrame
implements SwingChatClientHandler.Callback {
    private static final long serialVersionUID = 1538675161745436968L;
    private JTextField inputText;
    private JButton loginButton;
    private JButton quitButton;
    private JButton closeButton;
    private JTextField serverField;
    private JTextField nameField;
    private JTextArea area;
    private JScrollBar scroll;
    private ChatClientSupport client;
    private SwingChatClientHandler handler;
    private NioSocketConnector connector = new NioSocketConnector();

    public SwingChatClient() {
        super("Chat Client based on Apache MINA");
        this.loginButton = new JButton(new LoginAction());
        this.loginButton.setText("Connect");
        this.quitButton = new JButton(new LogoutAction());
        this.quitButton.setText("Disconnect");
        this.closeButton = new JButton(new QuitAction());
        this.closeButton.setText("Quit");
        this.inputText = new JTextField(30);
        this.inputText.setAction(new BroadcastAction());
        this.area = new JTextArea(10, 50);
        this.area.setLineWrap(true);
        this.area.setEditable(false);
        this.scroll = new JScrollBar();
        this.scroll.add(this.area);
        this.nameField = new JTextField(10);
        this.nameField.setEditable(false);
        this.serverField = new JTextField(10);
        this.serverField.setEditable(false);
        JPanel h = new JPanel();
        h.setLayout(new BoxLayout(h, 2));
        h.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel nameLabel = new JLabel("Name: ");
        JLabel serverLabel = new JLabel("Server: ");
        h.add(nameLabel);
        h.add(Box.createRigidArea(new Dimension(10, 0)));
        h.add(this.nameField);
        h.add(Box.createRigidArea(new Dimension(10, 0)));
        h.add(Box.createHorizontalGlue());
        h.add(Box.createRigidArea(new Dimension(10, 0)));
        h.add(serverLabel);
        h.add(Box.createRigidArea(new Dimension(10, 0)));
        h.add(this.serverField);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 3));
        left.add(this.area);
        left.add(Box.createRigidArea(new Dimension(0, 5)));
        left.add(Box.createHorizontalGlue());
        left.add(this.inputText);
        JPanel right = new JPanel();
        right.setLayout(new BoxLayout(right, 3));
        right.add(this.loginButton);
        right.add(Box.createRigidArea(new Dimension(0, 5)));
        right.add(this.quitButton);
        right.add(Box.createHorizontalGlue());
        right.add(Box.createRigidArea(new Dimension(0, 25)));
        right.add(this.closeButton);
        p.add(left);
        p.add(Box.createRigidArea(new Dimension(10, 0)));
        p.add(right);
        this.getContentPane().add((Component)h, "North");
        this.getContentPane().add(p);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingChatClient.this.client.quit();
                SwingChatClient.this.connector.dispose();
                SwingChatClient.this.dispose();
            }
        });
        this.setLoggedOut();
        this.setDefaultCloseOperation(3);
    }

    private void setLoggedOut() {
        this.inputText.setEnabled(false);
        this.quitButton.setEnabled(false);
        this.loginButton.setEnabled(true);
    }

    private void setLoggedIn() {
        this.area.setText("");
        this.inputText.setEnabled(true);
        this.quitButton.setEnabled(true);
        this.loginButton.setEnabled(false);
    }

    private void append(String text) {
        this.area.append(text);
    }

    private void notifyError(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    private SocketAddress parseSocketAddress(String s) {
        int colonIndex = (s = s.trim()).indexOf(":");
        if (colonIndex > 0) {
            String host = s.substring(0, colonIndex);
            int port = this.parsePort(s.substring(colonIndex + 1));
            return new InetSocketAddress(host, port);
        }
        int port = this.parsePort(s.substring(colonIndex + 1));
        return new InetSocketAddress(port);
    }

    private int parsePort(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Illegal port number: " + s);
        }
    }

    @Override
    public void connected() {
    }

    @Override
    public void disconnected() {
        this.append("Connection closed.\n");
        this.setLoggedOut();
    }

    @Override
    public void error(String message) {
        this.notifyError(message + "\n");
    }

    @Override
    public void loggedIn() {
        this.setLoggedIn();
        this.append("You have joined the chat session.\n");
    }

    @Override
    public void loggedOut() {
        this.append("You have left the chat session.\n");
        this.setLoggedOut();
    }

    @Override
    public void messageReceived(String message) {
        this.append(message + "\n");
    }

    public static void main(String[] args) {
        SwingChatClient client = new SwingChatClient();
        client.pack();
        client.setVisible(true);
    }

    public class LoginAction
    extends AbstractAction {
        private static final long serialVersionUID = 3596719854773863244L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ConnectDialog dialog = new ConnectDialog(SwingChatClient.this);
            dialog.pack();
            dialog.setVisible(true);
            if (dialog.isCancelled()) {
                return;
            }
            SocketAddress address = SwingChatClient.this.parseSocketAddress(dialog.getServerAddress());
            String name = dialog.getUsername();
            SwingChatClient.this.handler = new SwingChatClientHandler(SwingChatClient.this);
            SwingChatClient.this.client = new ChatClientSupport(name, (IoHandler)SwingChatClient.this.handler);
            SwingChatClient.this.nameField.setText(name);
            SwingChatClient.this.serverField.setText(dialog.getServerAddress());
            if (!SwingChatClient.this.client.connect(SwingChatClient.this.connector, address, dialog.isUseSsl())) {
                JOptionPane.showMessageDialog(SwingChatClient.this, "Could not connect to " + dialog.getServerAddress() + ". ");
            }
        }
    }

    private class LogoutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1655297424639924560L;

        private LogoutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SwingChatClient.this.client.quit();
                SwingChatClient.this.setLoggedOut();
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(SwingChatClient.this, "Session could not be closed.");
            }
        }
    }

    private class QuitAction
    extends AbstractAction {
        private static final long serialVersionUID = -6389802816912005370L;

        private QuitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SwingChatClient.this.client != null) {
                SwingChatClient.this.client.quit();
            }
            SwingChatClient.this.dispose();
        }
    }

    private class BroadcastAction
    extends AbstractAction {
        private static final long serialVersionUID = -6276019615521905411L;

        private BroadcastAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingChatClient.this.client.broadcast(SwingChatClient.this.inputText.getText());
            SwingChatClient.this.inputText.setText("");
        }
    }
}

