/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.chat;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.example.chat.ChatProtocolHandler;
import org.apache.mina.example.echoserver.ssl.BogusSSLContextFactory;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.filter.compression.CompressionFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filter.logging.MdcInjectionFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class Main {
    private static final int PORT = 1234;
    private static final boolean USE_SSL = true;

    public static void main(String[] args) throws Exception {
        NioSocketAcceptor acceptor = new NioSocketAcceptor();
        DefaultIoFilterChainBuilder chain = acceptor.getFilterChain();
        MdcInjectionFilter mdcInjectionFilter = new MdcInjectionFilter();
        chain.addLast("mdc", (IoFilter)mdcInjectionFilter);
        Main.addSSLSupport(chain);
        chain.addLast("Compressor", (IoFilter)new CompressionFilter());
        chain.addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory()));
        Main.addLogger(chain);
        acceptor.setHandler((IoHandler)new ChatProtocolHandler());
        acceptor.bind((SocketAddress)new InetSocketAddress(1234));
        System.out.println("Listening on port 1234");
    }

    private static void addSSLSupport(DefaultIoFilterChainBuilder chain) throws Exception {
        SslFilter sslFilter = new SslFilter(BogusSSLContextFactory.getInstance(true));
        chain.addLast("sslFilter", (IoFilter)sslFilter);
        System.out.println("SSL ON");
    }

    private static void addLogger(DefaultIoFilterChainBuilder chain) throws Exception {
        chain.addLast("logger", (IoFilter)new LoggingFilter());
        System.out.println("Logging ON");
    }
}

