/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.tennis;

import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.tennis.TennisBall;

public class TennisPlayer
extends IoHandlerAdapter {
    private static int nextId = 0;
    private final int id = nextId++;

    public void sessionOpened(IoSession session) {
        System.out.println("Player-" + this.id + ": READY");
    }

    public void sessionClosed(IoSession session) {
        System.out.println("Player-" + this.id + ": QUIT");
    }

    public void messageReceived(IoSession session, Object message) {
        System.out.println("Player-" + this.id + ": RCVD " + message);
        TennisBall ball = (TennisBall)message;
        ball = ball.stroke();
        if (ball.getTTL() > 0) {
            session.write((Object)ball);
        } else {
            System.out.println("Player-" + this.id + ": LOSE");
            session.closeNow();
        }
    }

    public void messageSent(IoSession session, Object message) {
        System.out.println("Player-" + this.id + ": SENT " + message);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        cause.printStackTrace();
        session.closeNow();
    }
}

