/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.netcat;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;

public class NetCatProtocolHandler
extends IoHandlerAdapter {
    public void sessionOpened(IoSession session) {
        session.getConfig().setIdleTime(IdleStatus.READER_IDLE, 10);
    }

    public void sessionClosed(IoSession session) {
        System.err.println("Total " + session.getReadBytes() + " byte(s)");
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        if (status == IdleStatus.READER_IDLE) {
            session.close(true);
        }
    }

    public void messageReceived(IoSession session, Object message) {
        IoBuffer buf = (IoBuffer)message;
        while (buf.hasRemaining()) {
            System.out.print((char)buf.get());
        }
        System.out.flush();
    }
}

