/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.echoserver.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.mina.example.echoserver.ssl.BogusSslContextFactory;

public class SslSocketFactory
extends SocketFactory {
    private static boolean sslEnabled = false;
    private static SSLSocketFactory sslFactory = null;
    private static SocketFactory factory = null;

    public Socket createSocket(String arg1, int arg2) throws IOException, UnknownHostException {
        if (SslSocketFactory.isSslEnabled()) {
            return this.getSSLFactory().createSocket(arg1, arg2);
        }
        return new Socket(arg1, arg2);
    }

    public Socket createSocket(String arg1, int arg2, InetAddress arg3, int arg4) throws IOException, UnknownHostException {
        if (SslSocketFactory.isSslEnabled()) {
            return this.getSSLFactory().createSocket(arg1, arg2, arg3, arg4);
        }
        return new Socket(arg1, arg2, arg3, arg4);
    }

    public Socket createSocket(InetAddress arg1, int arg2) throws IOException {
        if (SslSocketFactory.isSslEnabled()) {
            return this.getSSLFactory().createSocket(arg1, arg2);
        }
        return new Socket(arg1, arg2);
    }

    public Socket createSocket(InetAddress arg1, int arg2, InetAddress arg3, int arg4) throws IOException {
        if (SslSocketFactory.isSslEnabled()) {
            return this.getSSLFactory().createSocket(arg1, arg2, arg3, arg4);
        }
        return new Socket(arg1, arg2, arg3, arg4);
    }

    public static SocketFactory getSocketFactory() {
        if (factory == null) {
            factory = new SslSocketFactory();
        }
        return factory;
    }

    private SSLSocketFactory getSSLFactory() {
        if (sslFactory == null) {
            try {
                sslFactory = BogusSslContextFactory.getInstance(false).getSocketFactory();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("could not create SSL socket", e);
            }
        }
        return sslFactory;
    }

    public static boolean isSslEnabled() {
        return sslEnabled;
    }

    public static void setSslEnabled(boolean newSslEnabled) {
        sslEnabled = newSslEnabled;
    }
}

