/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.imagine.step1.codec;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.example.imagine.step1.ImageResponse;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class ImageResponseDecoder
extends CumulativeProtocolDecoder {
    private static final String DECODER_STATE_KEY = ImageResponseDecoder.class.getName() + ".STATE";
    public static final int MAX_IMAGE_SIZE = 0x500000;

    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        DecoderState decoderState = (DecoderState)session.getAttribute((Object)DECODER_STATE_KEY);
        if (decoderState == null) {
            decoderState = new DecoderState();
            session.setAttribute((Object)DECODER_STATE_KEY, (Object)decoderState);
        }
        if (decoderState.image1 == null) {
            if (in.prefixedDataAvailable(4, 0x500000)) {
                decoderState.image1 = this.readImage(in);
            } else {
                return false;
            }
        }
        if (decoderState.image1 != null) {
            if (in.prefixedDataAvailable(4, 0x500000)) {
                BufferedImage image2 = this.readImage(in);
                ImageResponse imageResponse = new ImageResponse(decoderState.image1, image2);
                out.write((Object)imageResponse);
                decoderState.image1 = null;
                return true;
            }
            return false;
        }
        return false;
    }

    private BufferedImage readImage(IoBuffer in) throws IOException {
        int length = in.getInt();
        byte[] bytes = new byte[length];
        in.get(bytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return ImageIO.read(bais);
    }

    private static class DecoderState {
        BufferedImage image1;

        private DecoderState() {
        }
    }
}

