/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.echoserver.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.mina.example.echoserver.ssl.BogusTrustManagerFactory;

public class BogusSslContextFactory {
    private static final String PROTOCOL = "TLS";
    private static final String KEY_MANAGER_FACTORY_ALGORITHM;
    private static final String BOGUS_KEYSTORE = "bogus.cert";
    private static final char[] BOGUS_PW;
    private static SSLContext serverInstance;
    private static SSLContext clientInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSLContext getInstance(boolean server) throws GeneralSecurityException {
        SSLContext retInstance = null;
        if (server) {
            if (serverInstance != null) return serverInstance;
            Class<BogusSslContextFactory> clazz = BogusSslContextFactory.class;
            synchronized (BogusSslContextFactory.class) {
                if (serverInstance != null) return serverInstance;
                try {
                    serverInstance = BogusSslContextFactory.createBougusServerSslContext();
                }
                catch (Exception ioe) {
                    throw new GeneralSecurityException("Can't create Server SSLContext:" + ioe);
                }
                return serverInstance;
            }
        }
        if (clientInstance != null) return clientInstance;
        Class<BogusSslContextFactory> clazz = BogusSslContextFactory.class;
        synchronized (BogusSslContextFactory.class) {
            if (clientInstance != null) return clientInstance;
            clientInstance = BogusSslContextFactory.createBougusClientSslContext();
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return clientInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLContext createBougusServerSslContext() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        InputStream in = null;
        try {
            in = BogusSslContextFactory.class.getResourceAsStream(BOGUS_KEYSTORE);
            ks.load(in, BOGUS_PW);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KEY_MANAGER_FACTORY_ALGORITHM);
        kmf.init(ks, BOGUS_PW);
        SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
        sslContext.init(kmf.getKeyManagers(), BogusTrustManagerFactory.X509_MANAGERS, null);
        return sslContext;
    }

    private static SSLContext createBougusClientSslContext() throws GeneralSecurityException {
        SSLContext context = SSLContext.getInstance(PROTOCOL);
        context.init(null, BogusTrustManagerFactory.X509_MANAGERS, null);
        return context;
    }

    static {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        KEY_MANAGER_FACTORY_ALGORITHM = algorithm;
        BOGUS_PW = new char[]{'b', 'o', 'g', 'u', 's', 'p', 'w'};
        serverInstance = null;
        clientInstance = null;
    }
}

