/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.proxy;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.common.TrafficMask;
import org.apache.mina.example.proxy.AbstractProxyIoHandler;
import org.apache.mina.example.proxy.ServerToProxyIoHandler;

public class ClientToProxyIoHandler
extends AbstractProxyIoHandler {
    private final ServerToProxyIoHandler connectorHandler;
    private final IoConnector connector;
    private final InetSocketAddress address;

    public ClientToProxyIoHandler(ServerToProxyIoHandler connectorHandler, IoConnector connector, InetSocketAddress address) {
        this.connectorHandler = connectorHandler;
        this.connector = connector;
        this.address = address;
    }

    public void sessionOpened(final IoSession session) throws Exception {
        this.connector.connect((SocketAddress)this.address, (IoHandler)this.connectorHandler).addListener(new IoFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(IoFuture f) {
                ConnectFuture future = (ConnectFuture)f;
                try {
                    future.getSession().setAttachment((Object)session);
                    session.setAttachment((Object)future.getSession());
                    future.getSession().setTrafficMask(TrafficMask.ALL);
                }
                catch (RuntimeIOException e) {
                    session.close();
                }
                finally {
                    session.setTrafficMask(TrafficMask.ALL);
                }
            }
        });
    }
}

