/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.httpserver.codec;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.example.httpserver.codec.HttpResponseMessage;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.demux.MessageEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponseEncoder
implements MessageEncoder {
    private static final Set<Class> TYPES;
    private static final byte[] CRLF;

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        HttpResponseMessage msg = (HttpResponseMessage)message;
        ByteBuffer buf = ByteBuffer.allocate((int)256);
        buf.setAutoExpand(true);
        try {
            CharsetEncoder encoder = Charset.defaultCharset().newEncoder();
            buf.putString((CharSequence)"HTTP/1.1 ", encoder);
            buf.putString((CharSequence)String.valueOf(msg.getResponseCode()), encoder);
            switch (msg.getResponseCode()) {
                case 200: {
                    buf.putString((CharSequence)" OK", encoder);
                    break;
                }
                case 404: {
                    buf.putString((CharSequence)" Not Found", encoder);
                }
            }
            buf.put(CRLF);
            for (Map.Entry entry : msg.getHeaders().entrySet()) {
                buf.putString((CharSequence)((String)entry.getKey()), encoder);
                buf.putString((CharSequence)": ", encoder);
                buf.putString((CharSequence)((String)entry.getValue()), encoder);
                buf.put(CRLF);
            }
            buf.putString((CharSequence)"Content-Length: ", encoder);
            buf.putString((CharSequence)String.valueOf(msg.getBodyLength()), encoder);
            buf.put(CRLF);
            buf.put(CRLF);
            buf.put(msg.getBody());
        }
        catch (CharacterCodingException ex) {
            ex.printStackTrace();
        }
        buf.flip();
        out.write(buf);
    }

    public Set<Class> getMessageTypes() {
        return TYPES;
    }

    static {
        HashSet<Class<HttpResponseMessage>> types = new HashSet<Class<HttpResponseMessage>>();
        types.add(HttpResponseMessage.class);
        TYPES = Collections.unmodifiableSet(types);
        CRLF = new byte[]{13, 10};
    }
}

