/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.codec.delimited.ints;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.mina.codec.IoBuffer;
import org.apache.mina.codec.ProtocolDecoderException;
import org.apache.mina.codec.delimited.ByteBufferEncoder;
import org.apache.mina.codec.delimited.IoBufferDecoder;
import org.apache.mina.codec.delimited.ints.IntTranscoder;

public final class VarInt
implements IntTranscoder {
    @Override
    public IoBufferDecoder<Integer> getDecoder() {
        return new Decoder();
    }

    @Override
    public ByteBufferEncoder<Integer> getEncoder() {
        return new Encoder();
    }

    private class Encoder
    extends ByteBufferEncoder<Integer> {
        private Encoder() {
        }

        @Override
        public void writeTo(Integer message, ByteBuffer buffer) {
            int value = Math.max(0, message);
            while (true) {
                if ((value & 0xFFFFFF80) == 0) {
                    buffer.put((byte)value);
                    return;
                }
                buffer.put((byte)(value & 0x7F | 0x80));
                value >>>= 7;
            }
        }

        @Override
        public int getEncodedSize(Integer value) {
            if ((value & 0xFFFFFF80) == 0) {
                return 1;
            }
            if ((value & 0xFFFFC000) == 0) {
                return 2;
            }
            if ((value & 0xFFE00000) == 0) {
                return 3;
            }
            if ((value & 0xF0000000) == 0) {
                return 4;
            }
            return 5;
        }
    }

    private class Decoder
    extends IoBufferDecoder<Integer> {
        private Decoder() {
        }

        @Override
        public Integer decode(IoBuffer input) {
            int origpos = input.position();
            try {
                byte tmp = input.get();
                if (tmp >= 0) {
                    return tmp;
                }
                int result = tmp & 0x7F;
                tmp = input.get();
                if (tmp >= 0) {
                    result |= tmp << 7;
                } else {
                    result |= (tmp & 0x7F) << 7;
                    tmp = input.get();
                    if (tmp >= 0) {
                        result |= tmp << 14;
                    } else {
                        result |= (tmp & 0x7F) << 14;
                        tmp = input.get();
                        if (tmp >= 0) {
                            result |= tmp << 21;
                        } else {
                            result |= (tmp & 0x7F) << 21;
                            tmp = input.get();
                            if ((tmp & 0xFFFFFFF8) == 0) {
                                result |= tmp << 28;
                            } else {
                                throw new ProtocolDecoderException("Not the varint representation of a signed int32");
                            }
                        }
                    }
                }
                return result;
            }
            catch (BufferUnderflowException bue) {
                input.position(origpos);
                return null;
            }
        }
    }
}

