/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.interactive;

import java.util.Arrays;
import org.apache.maven.wagon.providers.ssh.interactive.InteractiveUserInfo;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class ConsoleInteractiveUserInfo
implements InteractiveUserInfo {
    private volatile Prompter prompter;

    public ConsoleInteractiveUserInfo() {
    }

    public ConsoleInteractiveUserInfo(Prompter prompter) {
        this.prompter = prompter;
    }

    @Override
    public boolean promptYesNo(String message) {
        String ret;
        try {
            ret = this.prompter.prompt(message, Arrays.asList("yes", "no"));
        }
        catch (PrompterException e) {
            ret = null;
        }
        return "yes".equalsIgnoreCase(ret);
    }

    @Override
    public void showMessage(String message) {
        try {
            this.prompter.showMessage(message);
        }
        catch (PrompterException prompterException) {
            // empty catch block
        }
    }

    @Override
    public String promptPassword(String message) {
        try {
            return this.prompter.promptForPassword(message);
        }
        catch (PrompterException e) {
            return null;
        }
    }

    @Override
    public String promptPassphrase(String message) {
        return this.promptPassword(message);
    }
}

