/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.codehaus.plexus.util.StringUtils;

public class PojoStackTraceWriter
implements StackTraceWriter {
    private final Throwable t;
    protected final String testClass;
    protected final String testMethod;

    public PojoStackTraceWriter(String testClass, String testMethod, Throwable t) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.t = t;
    }

    public String writeTraceToString() {
        StringWriter w = new StringWriter();
        this.t.printStackTrace(new PrintWriter(w));
        w.flush();
        return w.toString();
    }

    public String writeTrimmedTraceToString() {
        int i;
        String text = this.writeTraceToString();
        String marker = "at " + this.testClass + "." + this.testMethod;
        String[] lines = StringUtils.split((String)text, (String)"\n");
        int lastLine = lines.length - 1;
        for (int i2 = 1; i2 < lines.length; ++i2) {
            if (!lines[i2].trim().startsWith(marker)) continue;
            lastLine = i2;
        }
        StringBuffer trace = new StringBuffer();
        for (i = 0; i <= lastLine; ++i) {
            trace.append(lines[i]);
            trace.append("\n");
        }
        for (i = lastLine; i < lines.length; ++i) {
            if (!lines[i].trim().startsWith("Caused by")) continue;
            lastLine = i;
            break;
        }
        for (i = lastLine; i < lines.length; ++i) {
            trace.append(lines[i]);
            trace.append("\n");
        }
        return trace.toString();
    }

    public Throwable getThrowable() {
        return this.t;
    }
}

