/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScanResult
implements ScanResult {
    private final List<String> files;
    private static final String scanResultNo = "tc.";

    public DefaultScanResult(List<String> files) {
        this.files = Collections.unmodifiableList(files);
    }

    @Override
    public int size() {
        return this.files.size();
    }

    @Override
    public String getClassName(int index) {
        return this.files.get(index);
    }

    @Override
    public void writeTo(Properties properties) {
        int size = this.files.size();
        for (int i = 0; i < size; ++i) {
            properties.setProperty(scanResultNo + i, this.files.get(i));
        }
    }

    public static DefaultScanResult from(Properties properties) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        String item;
        while ((item = properties.getProperty(scanResultNo + i++)) != null) {
            result.add(item);
        }
        return new DefaultScanResult(result);
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    public List getFiles() {
        return this.files;
    }

    @Override
    public TestsToRun applyFilter(ScannerFilter scannerFilter, ClassLoader testClassLoader) {
        ArrayList<Class> result = new ArrayList<Class>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            String className = this.getClassName(i);
            Class testClass = DefaultScanResult.loadClass(testClassLoader, className);
            if (scannerFilter != null && !scannerFilter.accept(testClass)) continue;
            result.add(testClass);
        }
        return new TestsToRun(result);
    }

    @Override
    public List getClassesSkippedByValidation(ScannerFilter scannerFilter, ClassLoader testClassLoader) {
        ArrayList<Class> result = new ArrayList<Class>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            String className = this.getClassName(i);
            Class testClass = DefaultScanResult.loadClass(testClassLoader, className);
            if (scannerFilter == null || scannerFilter.accept(testClass)) continue;
            result.add(testClass);
        }
        return result;
    }

    private static Class loadClass(ClassLoader classLoader, String className) {
        Class<?> testClass;
        try {
            testClass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to create test class '" + className + "'", e);
        }
        return testClass;
    }

    public DefaultScanResult append(DefaultScanResult other) {
        if (other != null) {
            ArrayList<String> src = new ArrayList<String>(this.files);
            src.addAll(other.files);
            return new DefaultScanResult(src);
        }
        return this;
    }
}

