/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.maven.shared.jar.JarData;

public class JarAnalyzer {
    private static final Pattern CLASS_FILTER = Pattern.compile("[A-Za-z0-9]*\\.class$");
    private static final Pattern MAVEN_POM_FILTER = Pattern.compile("META-INF/maven/.*/pom\\.xml$");
    private static final Pattern VERSION_FILTER = Pattern.compile("[Vv][Ee][Rr][Ss][Ii][Oo][Nn]");
    private final JarFile jarFile;
    private final JarData jarData;

    public JarAnalyzer(File file) throws IOException {
        Manifest manifest;
        try {
            this.jarFile = new JarFile(file);
        }
        catch (ZipException e) {
            ZipException ioe = new ZipException("Failed to open file " + file + " : " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        ArrayList<JarEntry> entries = Collections.list(this.jarFile.entries());
        entries.sort(Comparator.comparing(ZipEntry::getName));
        try {
            manifest = this.jarFile.getManifest();
        }
        catch (IOException e) {
            this.closeQuietly();
            throw e;
        }
        this.jarData = new JarData(file, manifest, entries);
    }

    public InputStream getEntryInputStream(JarEntry entry) throws IOException {
        return this.jarFile.getInputStream(entry);
    }

    public void closeQuietly() {
        try {
            this.jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<JarEntry> filterEntries(Pattern pattern) {
        return this.filterEntries(pattern, this.getEntries());
    }

    private List<JarEntry> filterEntries(Pattern pattern, List<JarEntry> entryList) {
        ArrayList<JarEntry> ret = new ArrayList<JarEntry>();
        for (JarEntry entry : entryList) {
            Matcher mat = pattern.matcher(entry.getName());
            if (!mat.find()) continue;
            ret.add(entry);
        }
        return ret;
    }

    public List<JarEntry> getClassEntries() {
        return this.filterEntries(CLASS_FILTER);
    }

    public List<JarEntry> getClassEntries(List<JarEntry> entryList) {
        return this.filterEntries(CLASS_FILTER, entryList);
    }

    public List<JarEntry> getMavenPomEntries() {
        return this.filterEntries(MAVEN_POM_FILTER);
    }

    public List<JarEntry> getVersionEntries() {
        return this.filterEntries(VERSION_FILTER);
    }

    public List<JarEntry> getEntries() {
        return this.jarData.getEntries();
    }

    public File getFile() {
        return this.jarData.getFile();
    }

    public JarData getJarData() {
        return this.jarData;
    }
}

