/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.runtime;

import java.io.Serializable;

public class MavenProjectProperties
implements Serializable {
    private static final long serialVersionUID = 5233832086526764232L;
    private final String groupId;
    private final String artifactId;
    private final String version;

    public MavenProjectProperties(String groupId, String artifactId, String version) {
        if (groupId == null) {
            throw new IllegalArgumentException("groupId cannot be null");
        }
        if (artifactId == null) {
            throw new IllegalArgumentException("artifactId cannot be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version cannot be null");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = hashCode * 37 + this.groupId.hashCode();
        hashCode = hashCode * 37 + this.artifactId.hashCode();
        hashCode = hashCode * 37 + this.version.hashCode();
        return hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MavenProjectProperties)) {
            return false;
        }
        MavenProjectProperties info = (MavenProjectProperties)object;
        return this.groupId.equals(info.getGroupId()) && this.artifactId.equals(info.getArtifactId()) && this.version.equals(info.getVersion());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append("[");
        buffer.append("groupId=").append(this.groupId).append(",");
        buffer.append("artifactId=").append(this.artifactId).append(",");
        buffer.append("version=").append(this.version);
        buffer.append("]");
        return buffer.toString();
    }
}

