/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.internal.DefaultDependencyNode;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.version.VersionConstraint;
import org.sonatype.aether.version.VersionRange;

@Component(role=DependencyGraphBuilder.class, hint="maven3")
public class Maven3DependencyGraphBuilder
extends AbstractLogEnabled
implements DependencyGraphBuilder {
    @Requirement
    private ProjectDependenciesResolver resolver;

    @Override
    public DependencyNode buildDependencyGraph(ProjectBuildingRequest buildingRequest, ArtifactFilter filter) throws DependencyGraphBuilderException {
        MavenProject project = buildingRequest.getProject();
        DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest(project, buildingRequest.getRepositorySession());
        DependencyFilter collectFilter = new DependencyFilter(){

            public boolean accept(org.sonatype.aether.graph.DependencyNode node, List<org.sonatype.aether.graph.DependencyNode> parents) {
                return false;
            }
        };
        request.setResolutionFilter(collectFilter);
        DependencyResolutionResult result = this.resolveDependencies((DependencyResolutionRequest)request);
        return this.buildDependencyNode(null, result.getDependencyGraph(), project.getArtifact(), filter);
    }

    private DependencyResolutionResult resolveDependencies(DependencyResolutionRequest request) throws DependencyGraphBuilderException {
        try {
            return this.resolver.resolve(request);
        }
        catch (DependencyResolutionException e) {
            throw new DependencyGraphBuilderException("Could not resolve following dependencies: " + e.getResult().getUnresolvedDependencies(), e);
        }
    }

    private org.apache.maven.artifact.Artifact getDependencyArtifact(Dependency dep) {
        org.apache.maven.artifact.Artifact mavenArtifact = RepositoryUtils.toArtifact((Artifact)dep.getArtifact());
        mavenArtifact.setScope(dep.getScope());
        mavenArtifact.setOptional(dep.isOptional());
        return mavenArtifact;
    }

    private DependencyNode buildDependencyNode(DependencyNode parent, org.sonatype.aether.graph.DependencyNode node, org.apache.maven.artifact.Artifact artifact, ArtifactFilter filter) {
        DefaultDependencyNode current = new DefaultDependencyNode(parent, artifact, null, null, this.getVersionSelectedFromRange(node.getVersionConstraint()));
        ArrayList<DependencyNode> nodes = new ArrayList<DependencyNode>(node.getChildren().size());
        for (org.sonatype.aether.graph.DependencyNode child : node.getChildren()) {
            org.apache.maven.artifact.Artifact childArtifact = this.getDependencyArtifact(child.getDependency());
            if (filter != null && !filter.include(childArtifact)) continue;
            nodes.add(this.buildDependencyNode(current, child, childArtifact, filter));
        }
        current.setChildren(Collections.unmodifiableList(nodes));
        return current;
    }

    private String getVersionSelectedFromRange(VersionConstraint constraint) {
        if (constraint == null || constraint.getVersion() != null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (VersionRange range : constraint.getRanges()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(range);
        }
        return sb.toString();
    }
}

