/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.tree.DependencyTreeInverseIterator;
import org.apache.maven.shared.dependency.tree.DependencyTreePreorderIterator;

public class DependencyNode {
    DependencyNode parent;
    Artifact artifact;
    int depth;
    List children = new ArrayList();

    DependencyNode() {
    }

    public DependencyNode getParent() {
        return this.parent;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public int getDepth() {
        return this.depth;
    }

    public List getChildren() {
        return this.children;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentDepth) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indentDepth; ++i) {
            sb.append(" ");
        }
        sb.append(this.artifact == null ? null : this.artifact.toString());
        sb.append("\n");
        if (this.getChildren() != null) {
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                DependencyNode dependencyNode = (DependencyNode)it.next();
                sb.append(dependencyNode.toString(indentDepth + 2));
            }
        }
        return sb.toString();
    }

    public Iterator iterator() {
        return this.preorderIterator();
    }

    public Iterator preorderIterator() {
        return new DependencyTreePreorderIterator(this);
    }

    public Iterator inverseIterator() {
        return new DependencyTreeInverseIterator(this);
    }
}

