/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer.asm;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ConstantPoolParser {
    public static final int HEAD = -889275714;
    public static final byte CONSTANT_UTF8 = 1;
    public static final byte CONSTANT_INTEGER = 3;
    public static final byte CONSTANT_FLOAT = 4;
    public static final byte CONSTANT_LONG = 5;
    public static final byte CONSTANT_DOUBLE = 6;
    public static final byte CONSTANT_CLASS = 7;
    public static final byte CONSTANT_STRING = 8;
    public static final byte CONSTANT_FIELDREF = 9;
    public static final byte CONSTANT_METHODREF = 10;
    public static final byte CONSTANT_INTERFACEMETHODREF = 11;
    public static final byte CONSTANT_NAME_AND_TYPE = 12;
    public static final byte CONSTANT_METHODHANDLE = 15;
    public static final byte CONSTANT_METHOD_TYPE = 16;
    public static final byte CONSTANT_INVOKE_DYNAMIC = 18;
    private static final int OXF0 = 240;
    private static final int OXE0 = 224;
    private static final int OX3F = 63;

    static Set<String> getConstantPoolClassReferences(byte[] b) {
        return ConstantPoolParser.parseConstantPoolClassReferences(ByteBuffer.wrap(b));
    }

    static Set<String> parseConstantPoolClassReferences(ByteBuffer buf) {
        if (buf.order(ByteOrder.BIG_ENDIAN).getInt() != -889275714) {
            return Collections.emptySet();
        }
        buf.getChar();
        buf.getChar();
        HashSet<Integer> classes = new HashSet<Integer>();
        HashMap<Integer, String> stringConstants = new HashMap<Integer, String>();
        int num = buf.getChar();
        block11: for (int ix = 1; ix < num; ++ix) {
            byte tag = buf.get();
            switch (tag) {
                default: {
                    throw new RuntimeException("Unknown constant pool type");
                }
                case 1: {
                    stringConstants.put(ix, ConstantPoolParser.decodeString(buf));
                    continue block11;
                }
                case 7: 
                case 8: 
                case 16: {
                    classes.add(Integer.valueOf(buf.getChar()));
                    continue block11;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    buf.getChar();
                    buf.getChar();
                    continue block11;
                }
                case 3: {
                    buf.getInt();
                    continue block11;
                }
                case 4: {
                    buf.getFloat();
                    continue block11;
                }
                case 6: {
                    buf.getDouble();
                    ++ix;
                    continue block11;
                }
                case 5: {
                    buf.getLong();
                    ++ix;
                    continue block11;
                }
                case 15: {
                    buf.get();
                    buf.getChar();
                    continue block11;
                }
                case 18: {
                    buf.getChar();
                    buf.getChar();
                }
            }
        }
        HashSet<String> result = new HashSet<String>();
        for (Integer aClass : classes) {
            result.add((String)stringConstants.get(aClass));
        }
        return result;
    }

    private static String decodeString(ByteBuffer buf) {
        char size = buf.getChar();
        int oldLimit = buf.limit();
        buf.limit(buf.position() + size);
        StringBuilder sb = new StringBuilder(size + (size >> 1) + 16);
        while (buf.hasRemaining()) {
            byte b = buf.get();
            if (b > 0) {
                sb.append((char)b);
                continue;
            }
            byte b2 = buf.get();
            if ((b & 0xF0) != 224) {
                sb.append((char)((b & 0x1F) << 6 | b2 & 0x3F));
                continue;
            }
            byte b3 = buf.get();
            sb.append((char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F));
        }
        buf.limit(oldLimit);
        return sb.toString();
    }
}

