/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer;

public class DependencyUsage {
    private final String dependencyClass;
    private final String usedBy;

    public DependencyUsage(String dependencyClass, String usedBy) {
        this.dependencyClass = dependencyClass;
        this.usedBy = usedBy;
    }

    public String getDependencyClass() {
        return this.dependencyClass;
    }

    public String getUsedBy() {
        return this.usedBy;
    }

    public int hashCode() {
        int hashCode = this.dependencyClass.hashCode();
        hashCode = hashCode * 37 + this.usedBy.hashCode();
        return hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DependencyUsage) {
            DependencyUsage usage = (DependencyUsage)object;
            return this.getDependencyClass().equals(usage.getDependencyClass()) && this.getUsedBy().equals(usage.getUsedBy());
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("dependencyClass=").append(this.getDependencyClass());
        buffer.append(",");
        buffer.append("usedBy=").append(this.getUsedBy());
        buffer.insert(0, "[");
        buffer.insert(0, this.getClass().getName());
        buffer.append("]");
        return buffer.toString();
    }
}

