/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.internal.test.util.TestVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.VersionScheme;

public class NodeBuilder {
    private String groupId = "test";
    private String artifactId = "";
    private String version = "0.1";
    private String range;
    private String ext = "jar";
    private final String classifier = "";
    private String scope = "compile";
    private boolean optional = false;
    private String context;
    private final List<Artifact> relocations = new ArrayList<Artifact>();
    private final VersionScheme versionScheme = new TestVersionScheme();
    private Map<String, String> properties = new HashMap<String, String>(0);

    public NodeBuilder artifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public NodeBuilder groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public NodeBuilder ext(String ext) {
        this.ext = ext;
        return this;
    }

    public NodeBuilder version(String version) {
        this.version = version;
        this.range = null;
        return this;
    }

    public NodeBuilder range(String range) {
        this.range = range;
        return this;
    }

    public NodeBuilder scope(String scope) {
        this.scope = scope;
        return this;
    }

    public NodeBuilder optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public NodeBuilder context(String context) {
        this.context = context;
        return this;
    }

    public NodeBuilder reloc(String artifactId) {
        DefaultArtifact relocation = new DefaultArtifact(this.groupId, artifactId, "", this.ext, this.version);
        this.relocations.add((Artifact)relocation);
        return this;
    }

    public NodeBuilder reloc(String groupId, String artifactId, String version) {
        DefaultArtifact relocation = new DefaultArtifact(groupId, artifactId, "", this.ext, version);
        this.relocations.add((Artifact)relocation);
        return this;
    }

    public NodeBuilder properties(Map<String, String> properties) {
        this.properties = properties != null ? properties : Collections.emptyMap();
        return this;
    }

    public DependencyNode build() {
        Dependency dependency = null;
        if (this.artifactId != null && !this.artifactId.isEmpty()) {
            DefaultArtifact artifact = new DefaultArtifact(this.groupId, this.artifactId, "", this.ext, this.version, this.properties, (File)null);
            dependency = new Dependency((Artifact)artifact, this.scope, Boolean.valueOf(this.optional));
        }
        DefaultDependencyNode node = new DefaultDependencyNode(dependency);
        if (this.artifactId != null && !this.artifactId.isEmpty()) {
            try {
                node.setVersion(this.versionScheme.parseVersion(this.version));
                node.setVersionConstraint(this.versionScheme.parseVersionConstraint(this.range != null ? this.range : this.version));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalArgumentException("bad version: " + e.getMessage(), e);
            }
        }
        node.setRequestContext(this.context);
        node.setRelocations(this.relocations);
        return node;
    }
}

