/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.checksum.FileTrustedChecksumsSourceSupport;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilterSource;
import org.eclipse.aether.spi.remoterepo.RepositoryKeyFunctionFactory;
import org.eclipse.aether.util.DirectoryUtils;

public abstract class RemoteRepositoryFilterSourceSupport
implements RemoteRepositoryFilterSource {
    protected static final String CONFIG_PROPS_PREFIX = "aether.remoteRepositoryFilter.";
    public static final String CONFIG_PROP_REPOSITORY_KEY_FUNCTION = "aether.remoteRepositoryFilter.repositoryKeyFunction";
    public static final String DEFAULT_REPOSITORY_KEY_FUNCTION = "nid";
    private final RepositoryKeyFunctionFactory repositoryKeyFunctionFactory;

    protected RemoteRepositoryFilterSourceSupport(RepositoryKeyFunctionFactory repositoryKeyFunctionFactory) {
        this.repositoryKeyFunctionFactory = Objects.requireNonNull(repositoryKeyFunctionFactory);
    }

    protected abstract boolean isEnabled(RepositorySystemSession var1);

    protected Path getBasedir(RepositorySystemSession session, String defaultValue, String configPropKey, boolean mayCreate) {
        try {
            return DirectoryUtils.resolveDirectory((RepositorySystemSession)session, (String)defaultValue, (String)configPropKey, (boolean)mayCreate);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected RemoteRepository normalizeRemoteRepository(RepositorySystemSession session, RemoteRepository remoteRepository) {
        return remoteRepository.toBareRemoteRepository();
    }

    protected String repositoryKey(RepositorySystemSession session, RemoteRepository repository) {
        return this.repositoryKeyFunctionFactory.repositoryKeyFunction(FileTrustedChecksumsSourceSupport.class, session, DEFAULT_REPOSITORY_KEY_FUNCTION, CONFIG_PROP_REPOSITORY_KEY_FUNCTION).apply(repository, null);
    }

    static RemoteRepositoryFilter.Result result(boolean accepted, String name, String message) {
        return new SimpleResult(accepted, name + ": " + message);
    }

    private static class SimpleResult
    implements RemoteRepositoryFilter.Result {
        private final boolean accepted;
        private final String reasoning;

        private SimpleResult(boolean accepted, String reasoning) {
            this.accepted = accepted;
            this.reasoning = Objects.requireNonNull(reasoning);
        }

        public boolean isAccepted() {
            return this.accepted;
        }

        public String reasoning() {
            return this.reasoning;
        }
    }
}

