/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.internal.impl.filter.RemoteRepositoryFilterSourceSupport;
import org.eclipse.aether.internal.impl.filter.prefixes.PrefixesSource;
import org.eclipse.aether.internal.impl.filter.ruletree.PrefixTree;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.remoterepo.RepositoryKeyFunctionFactory;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="prefixes")
public final class PrefixesRemoteRepositoryFilterSource
extends RemoteRepositoryFilterSourceSupport {
    public static final String NAME = "prefixes";
    static final String PREFIX_FILE_TYPE = ".meta/prefixes.txt";
    public static final String CONFIG_PROP_ENABLED = "aether.remoteRepositoryFilter.prefixes";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String CONFIG_PROP_SKIPPED = "aether.remoteRepositoryFilter.prefixes.skipped";
    public static final boolean DEFAULT_SKIPPED = false;
    public static final String CONFIG_PROP_NO_INPUT_OUTCOME = "aether.remoteRepositoryFilter.prefixes.noInputOutcome";
    public static final boolean DEFAULT_NO_INPUT_OUTCOME = true;
    public static final String CONFIG_PROP_RESOLVE_PREFIX_FILES = "aether.remoteRepositoryFilter.prefixes.resolvePrefixFiles";
    public static final boolean DEFAULT_RESOLVE_PREFIX_FILES = true;
    public static final String CONFIG_PROP_USE_MIRRORED_REPOSITORIES = "aether.remoteRepositoryFilter.prefixes.useMirroredRepositories";
    public static final boolean DEFAULT_USE_MIRRORED_REPOSITORIES = false;
    public static final String CONFIG_PROP_USE_REPOSITORY_MANAGERS = "aether.remoteRepositoryFilter.prefixes.useRepositoryManagers";
    public static final boolean DEFAULT_USE_REPOSITORY_MANAGERS = false;
    public static final String CONFIG_PROP_BASEDIR = "aether.remoteRepositoryFilter.prefixes.basedir";
    public static final String LOCAL_REPO_PREFIX_DIR = ".remoteRepositoryFilters";
    static final String PREFIXES_FILE_PREFIX = "prefixes-";
    static final String PREFIXES_FILE_SUFFIX = ".txt";
    private final Logger logger = LoggerFactory.getLogger(PrefixesRemoteRepositoryFilterSource.class);
    private final Supplier<MetadataResolver> metadataResolver;
    private final Supplier<RemoteRepositoryManager> remoteRepositoryManager;
    private final RepositoryLayoutProvider repositoryLayoutProvider;
    private static final PrefixTree DISABLED = new PrefixTree("disabled");
    private static final PrefixTree ENABLED_NO_INPUT = new PrefixTree("enabled-no-input");
    private static final RepositoryLayout NOT_SUPPORTED = new RepositoryLayout(){

        public List<ChecksumAlgorithmFactory> getChecksumAlgorithmFactories() {
            throw new UnsupportedOperationException();
        }

        public boolean hasChecksums(Artifact artifact) {
            throw new UnsupportedOperationException();
        }

        public URI getLocation(Artifact artifact, boolean upload) {
            throw new UnsupportedOperationException();
        }

        public URI getLocation(Metadata metadata, boolean upload) {
            throw new UnsupportedOperationException();
        }

        public List<RepositoryLayout.ChecksumLocation> getChecksumLocations(Artifact artifact, boolean upload, URI location) {
            throw new UnsupportedOperationException();
        }

        public List<RepositoryLayout.ChecksumLocation> getChecksumLocations(Metadata metadata, boolean upload, URI location) {
            throw new UnsupportedOperationException();
        }
    };

    @Inject
    public PrefixesRemoteRepositoryFilterSource(RepositoryKeyFunctionFactory repositoryKeyFunctionFactory, Supplier<MetadataResolver> metadataResolver, Supplier<RemoteRepositoryManager> remoteRepositoryManager, RepositoryLayoutProvider repositoryLayoutProvider) {
        super(repositoryKeyFunctionFactory);
        this.metadataResolver = Objects.requireNonNull(metadataResolver);
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager);
        this.repositoryLayoutProvider = Objects.requireNonNull(repositoryLayoutProvider);
    }

    private ConcurrentMap<RemoteRepository, PrefixTree> prefixes(RepositorySystemSession session) {
        return (ConcurrentMap)session.getData().computeIfAbsent((Object)(this.getClass().getName() + ".prefixes"), ConcurrentHashMap::new);
    }

    private ConcurrentMap<RemoteRepository, RepositoryLayout> layouts(RepositorySystemSession session) {
        return (ConcurrentMap)session.getData().computeIfAbsent((Object)(this.getClass().getName() + ".layouts"), ConcurrentHashMap::new);
    }

    @Override
    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{CONFIG_PROP_ENABLED}) && !ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_SKIPPED});
    }

    private boolean isRepositoryFilteringEnabled(RepositorySystemSession session, RemoteRepository remoteRepository) {
        if (this.isEnabled(session)) {
            return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{"aether.remoteRepositoryFilter.prefixes." + remoteRepository.getId(), "aether.remoteRepositoryFilter.prefixes.*"}) && !ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{"aether.remoteRepositoryFilter.prefixes.skipped." + remoteRepository.getId(), "aether.remoteRepositoryFilter.prefixes.skipped.*"});
        }
        return false;
    }

    public RemoteRepositoryFilter getRemoteRepositoryFilter(RepositorySystemSession session) {
        if (this.isEnabled(session)) {
            return new PrefixesFilter(session, this.getBasedir(session, LOCAL_REPO_PREFIX_DIR, CONFIG_PROP_BASEDIR, false));
        }
        return null;
    }

    private RepositoryLayout cacheLayout(RepositorySystemSession session, RemoteRepository remoteRepository) {
        return this.layouts(session).computeIfAbsent(this.normalizeRemoteRepository(session, remoteRepository), r -> {
            try {
                return this.repositoryLayoutProvider.newRepositoryLayout(session, remoteRepository);
            }
            catch (NoRepositoryLayoutException e) {
                return NOT_SUPPORTED;
            }
        });
    }

    private PrefixTree cachePrefixTree(RepositorySystemSession session, Path basedir, RemoteRepository remoteRepository) {
        return this.prefixes(session).computeIfAbsent(this.normalizeRemoteRepository(session, remoteRepository), r -> this.loadPrefixTree(session, basedir, remoteRepository));
    }

    private PrefixTree loadPrefixTree(RepositorySystemSession session, Path baseDir, RemoteRepository remoteRepository) {
        if (this.isRepositoryFilteringEnabled(session, remoteRepository)) {
            String origin = "user-provided";
            Path filePath = this.resolvePrefixesFromLocalConfiguration(session, baseDir, remoteRepository);
            if (filePath == null) {
                if (!this.supportedResolvePrefixesForRemoteRepository(session, remoteRepository)) {
                    origin = "unsupported";
                } else {
                    origin = "auto-discovered";
                    filePath = this.resolvePrefixesFromRemoteRepository(session, remoteRepository);
                }
            }
            if (filePath != null) {
                PrefixesSource prefixesSource = PrefixesSource.of(remoteRepository, filePath);
                if (prefixesSource.valid()) {
                    this.logger.debug("Loaded prefixes for remote repository {} from {} file '{}'", new Object[]{prefixesSource.origin().getId(), origin, prefixesSource.path()});
                    PrefixTree prefixTree = new PrefixTree("");
                    int rules = prefixTree.loadNodes(prefixesSource.entries().stream());
                    this.logger.info("Loaded {} {} prefixes for remote repository {} ({})", new Object[]{rules, origin, prefixesSource.origin().getId(), prefixesSource.path().getFileName()});
                    return prefixTree;
                }
                this.logger.info("Rejected {} prefixes for remote repository {} ({}): {}", new Object[]{origin, prefixesSource.origin().getId(), prefixesSource.path().getFileName(), prefixesSource.message()});
            }
            this.logger.debug("Prefix file for remote repository {} not available", (Object)remoteRepository);
            return ENABLED_NO_INPUT;
        }
        this.logger.debug("Prefix file for remote repository {} disabled", (Object)remoteRepository);
        return DISABLED;
    }

    private Path resolvePrefixesFromLocalConfiguration(RepositorySystemSession session, Path baseDir, RemoteRepository remoteRepository) {
        Path filePath = baseDir.resolve(PREFIXES_FILE_PREFIX + this.repositoryKey(session, remoteRepository) + PREFIXES_FILE_SUFFIX);
        if (Files.isReadable(filePath)) {
            return filePath;
        }
        return null;
    }

    private boolean supportedResolvePrefixesForRemoteRepository(RepositorySystemSession session, RemoteRepository remoteRepository) {
        if (!ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{"aether.remoteRepositoryFilter.prefixes.resolvePrefixFiles." + remoteRepository.getId(), CONFIG_PROP_RESOLVE_PREFIX_FILES})) {
            return false;
        }
        if (remoteRepository.isRepositoryManager()) {
            return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_USE_REPOSITORY_MANAGERS});
        }
        return remoteRepository.getMirroredRepositories().isEmpty() || ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_USE_MIRRORED_REPOSITORIES});
    }

    private Path resolvePrefixesFromRemoteRepository(RepositorySystemSession session, RemoteRepository remoteRepository) {
        MetadataResolver mr = this.metadataResolver.get();
        RemoteRepositoryManager rm = this.remoteRepositoryManager.get();
        if (mr != null && rm != null) {
            RemoteRepository prepared = rm.aggregateRepositories(session, Collections.emptyList(), Collections.singletonList(remoteRepository), true).get(0);
            MetadataResult result = mr.resolveMetadata((RepositorySystemSession)new DefaultRepositorySystemSession(session).setTransferListener(null).setConfigProperty(CONFIG_PROP_SKIPPED, (Object)Boolean.TRUE.toString()), Collections.singleton(new MetadataRequest((Metadata)new DefaultMetadata(PREFIX_FILE_TYPE, Metadata.Nature.RELEASE_OR_SNAPSHOT)).setRepository(prepared).setDeleteLocalCopyIfMissing(true).setFavorLocalRepository(true))).get(0);
            if (result.isResolved()) {
                return result.getMetadata().getPath();
            }
            return null;
        }
        return null;
    }

    private class PrefixesFilter
    implements RemoteRepositoryFilter {
        private final RepositorySystemSession session;
        private final Path basedir;

        private PrefixesFilter(RepositorySystemSession session, Path basedir) {
            this.session = session;
            this.basedir = basedir;
        }

        public RemoteRepositoryFilter.Result acceptArtifact(RemoteRepository remoteRepository, Artifact artifact) {
            RepositoryLayout repositoryLayout = PrefixesRemoteRepositoryFilterSource.this.cacheLayout(this.session, remoteRepository);
            if (repositoryLayout == NOT_SUPPORTED) {
                return RemoteRepositoryFilterSourceSupport.result(true, PrefixesRemoteRepositoryFilterSource.NAME, "Unsupported layout: " + remoteRepository);
            }
            return this.acceptPrefix(remoteRepository, repositoryLayout.getLocation(artifact, false).getPath());
        }

        public RemoteRepositoryFilter.Result acceptMetadata(RemoteRepository remoteRepository, Metadata metadata) {
            RepositoryLayout repositoryLayout = PrefixesRemoteRepositoryFilterSource.this.cacheLayout(this.session, remoteRepository);
            if (repositoryLayout == NOT_SUPPORTED) {
                return RemoteRepositoryFilterSourceSupport.result(true, PrefixesRemoteRepositoryFilterSource.NAME, "Unsupported layout: " + remoteRepository);
            }
            return this.acceptPrefix(remoteRepository, repositoryLayout.getLocation(metadata, false).getPath());
        }

        private RemoteRepositoryFilter.Result acceptPrefix(RemoteRepository repository, String path) {
            boolean accepted;
            PrefixTree prefixTree = PrefixesRemoteRepositoryFilterSource.this.cachePrefixTree(this.session, this.basedir, repository);
            if (prefixTree == DISABLED) {
                return RemoteRepositoryFilterSourceSupport.result(true, PrefixesRemoteRepositoryFilterSource.NAME, "Disabled");
            }
            if (prefixTree == ENABLED_NO_INPUT) {
                return RemoteRepositoryFilterSourceSupport.result(ConfigUtils.getBoolean((RepositorySystemSession)this.session, (boolean)true, (String[])new String[]{"aether.remoteRepositoryFilter.prefixes.noInputOutcome." + repository.getId(), PrefixesRemoteRepositoryFilterSource.CONFIG_PROP_NO_INPUT_OUTCOME}), PrefixesRemoteRepositoryFilterSource.NAME, "No input available");
            }
            return RemoteRepositoryFilterSourceSupport.result(accepted, PrefixesRemoteRepositoryFilterSource.NAME, (accepted = prefixTree.acceptedPath(path)) ? "Path " + path + " allowed from " + repository.getId() : "Path " + path + " NOT allowed from " + repository.getId());
        }
    }
}

