/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.impl.scope;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.aether.impl.scope.BuildPath;
import org.eclipse.aether.impl.scope.BuildScope;
import org.eclipse.aether.impl.scope.BuildScopeQuery;
import org.eclipse.aether.impl.scope.BuildScopeSource;
import org.eclipse.aether.impl.scope.ProjectPath;

public final class BuildScopeMatrixSource
implements BuildScopeSource {
    private final Set<ProjectPath> projectPaths;
    private final Set<BuildPath> buildPaths;
    private final Map<String, BuildScope> buildScopes;

    public BuildScopeMatrixSource(Collection<ProjectPath> projectPaths, Collection<BuildPath> buildPaths, BuildScope ... extras) {
        Objects.requireNonNull(projectPaths, "projectPath");
        Objects.requireNonNull(buildPaths, "buildPaths");
        if (projectPaths.isEmpty() || buildPaths.isEmpty()) {
            throw new IllegalArgumentException("empty matrix");
        }
        HashMap<String, BuildScope> buildScopes = new HashMap<String, BuildScope>();
        AtomicInteger counter = new AtomicInteger(0);
        buildPaths.stream().sorted(Comparator.comparing(BuildPath::order)).forEach(buildPath -> {
            Stream<ProjectPath> projectPathStream = buildPath.isReverse() ? projectPaths.stream().sorted(Comparator.comparing(ProjectPath::reverseOrder)) : projectPaths.stream().sorted(Comparator.comparing(ProjectPath::order));
            projectPathStream.forEach(projectPath -> {
                String id = this.createId((ProjectPath)projectPath, (BuildPath)buildPath);
                buildScopes.put(id, new BuildScopeImpl(id, Collections.singleton(projectPath), Collections.singleton(buildPath), counter.incrementAndGet()));
            });
        });
        for (BuildScope extra : extras) {
            buildScopes.put(extra.getId(), extra);
        }
        this.buildScopes = Collections.unmodifiableMap(buildScopes);
        HashSet<ProjectPath> pp = new HashSet<ProjectPath>(projectPaths);
        HashSet<BuildPath> bp = new HashSet<BuildPath>(buildPaths);
        buildScopes.values().forEach(s -> {
            pp.addAll(s.getProjectPaths());
            bp.addAll(s.getBuildPaths());
        });
        this.projectPaths = Collections.unmodifiableSet(pp);
        this.buildPaths = Collections.unmodifiableSet(bp);
    }

    private String createId(ProjectPath projectPath, BuildPath buildPath) {
        return projectPath.getId() + "-" + buildPath.getId();
    }

    @Override
    public Collection<BuildScope> query(Collection<BuildScopeQuery> queries) {
        HashSet<BuildScope> result = new HashSet<BuildScope>();
        block7: for (BuildScopeQuery query : queries) {
            switch (query.getMode()) {
                case ALL: {
                    result.addAll(this.all());
                    continue block7;
                }
                case BY_PROJECT_PATH: {
                    result.addAll(this.byProjectPath(query.getProjectPath()));
                    continue block7;
                }
                case BY_BUILD_PATH: {
                    result.addAll(this.byBuildPath(query.getBuildPath()));
                    continue block7;
                }
                case SELECT: {
                    result.addAll(this.select(query.getProjectPath(), query.getBuildPath()));
                    continue block7;
                }
                case SINGLETON: {
                    result.addAll(this.singleton(query.getProjectPath(), query.getBuildPath()));
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unsupported query");
        }
        return result;
    }

    @Override
    public Collection<ProjectPath> allProjectPaths() {
        return this.projectPaths;
    }

    @Override
    public Collection<BuildPath> allBuildPaths() {
        return this.buildPaths;
    }

    private Collection<BuildScope> all() {
        return this.buildScopes.values();
    }

    private Collection<BuildScope> byProjectPath(ProjectPath projectPath) {
        return this.all().stream().filter(s -> s.getProjectPaths().contains(projectPath)).collect(Collectors.toSet());
    }

    private Collection<BuildScope> byBuildPath(BuildPath buildPath) {
        return this.all().stream().filter(s -> s.getBuildPaths().contains(buildPath)).collect(Collectors.toSet());
    }

    private Collection<BuildScope> singleton(ProjectPath projectPath, BuildPath buildPath) {
        BuildScope result = this.buildScopes.get(this.createId(projectPath, buildPath));
        if (result == null) {
            throw new IllegalArgumentException("no such build scope");
        }
        return Collections.singleton(result);
    }

    private Collection<BuildScope> select(ProjectPath projectPath, BuildPath buildPath) {
        HashSet<BuildScope> result = new HashSet<BuildScope>();
        this.buildScopes.values().stream().filter(s -> s.getProjectPaths().contains(projectPath) && s.getBuildPaths().contains(buildPath)).forEach(result::add);
        return result;
    }

    private static final class BuildScopeImpl
    implements BuildScope {
        private final String id;
        private final Set<ProjectPath> projectPaths;
        private final Set<BuildPath> buildPaths;
        private final int order;

        private BuildScopeImpl(String id, Set<ProjectPath> projectPaths, Set<BuildPath> buildPaths, int order) {
            this.id = id;
            this.projectPaths = projectPaths;
            this.buildPaths = buildPaths;
            this.order = order;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Set<ProjectPath> getProjectPaths() {
            return this.projectPaths;
        }

        @Override
        public Set<BuildPath> getBuildPaths() {
            return this.buildPaths;
        }

        @Override
        public int order() {
            return this.order;
        }
    }
}

