/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter.ruletree;

import java.util.HashMap;

class Node {
    private final String name;
    private final boolean stop;
    private final Boolean allow;
    private final HashMap<String, Node> siblings;

    protected Node(String name, boolean stop, Boolean allow) {
        this.name = name;
        this.stop = stop;
        this.allow = allow;
        this.siblings = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public boolean isLeaf() {
        return this.siblings.isEmpty();
    }

    public boolean isStop() {
        return this.stop;
    }

    public Boolean isAllow() {
        return this.allow;
    }

    protected Node addSibling(String name, boolean stop, Boolean allow) {
        return this.siblings.computeIfAbsent(name, n -> new Node((String)n, stop, allow));
    }

    protected Node getSibling(String name) {
        return this.siblings.get(name);
    }

    public String toString() {
        return (this.allow != null ? (this.allow.booleanValue() ? "+" : "-") : "?") + (this.stop ? "=" : "") + this.name;
    }

    public void dump(String prefix) {
        System.out.println(prefix + this);
        for (Node node : this.siblings.values()) {
            node.dump(prefix + "  ");
        }
    }
}

