/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.internal.impl.LocalPathPrefixComposer;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManager;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.RemoteRepository;

class EnhancedLocalRepositoryManager
extends SimpleLocalRepositoryManager {
    private static final String LOCAL_REPO_ID = "";
    private final String trackingFilename;
    private final TrackingFileManager trackingFileManager;
    private final LocalPathPrefixComposer localPathPrefixComposer;

    EnhancedLocalRepositoryManager(Path basedir, LocalPathComposer localPathComposer, Function<ArtifactRepository, String> idToPathSegmentFunction, String trackingFilename, TrackingFileManager trackingFileManager, LocalPathPrefixComposer localPathPrefixComposer) {
        super(basedir, "enhanced", localPathComposer, idToPathSegmentFunction);
        this.trackingFilename = Objects.requireNonNull(trackingFilename);
        this.trackingFileManager = Objects.requireNonNull(trackingFileManager);
        this.localPathPrefixComposer = Objects.requireNonNull(localPathPrefixComposer);
    }

    private String concatPaths(String prefix, String artifactPath) {
        if (prefix == null || prefix.isEmpty()) {
            return artifactPath;
        }
        return prefix + '/' + artifactPath;
    }

    @Override
    public String getPathForLocalArtifact(Artifact artifact) {
        return this.concatPaths(this.localPathPrefixComposer.getPathPrefixForLocalArtifact(artifact), super.getPathForLocalArtifact(artifact));
    }

    @Override
    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.concatPaths(this.localPathPrefixComposer.getPathPrefixForRemoteArtifact(artifact, repository), super.getPathForRemoteArtifact(artifact, repository, context));
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata) {
        return this.concatPaths(this.localPathPrefixComposer.getPathPrefixForLocalMetadata(metadata), super.getPathForLocalMetadata(metadata));
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.concatPaths(this.localPathPrefixComposer.getPathPrefixForRemoteMetadata(metadata, repository), super.getPathForRemoteMetadata(metadata, repository, context));
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        Path filePath;
        Artifact artifact = request.getArtifact();
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (Objects.equals(artifact.getVersion(), artifact.getBaseVersion())) {
            filePath = this.getAbsolutePathForLocalArtifact(artifact);
            this.checkFind(filePath, result);
        }
        if (!result.isAvailable()) {
            for (RemoteRepository repository : request.getRepositories()) {
                filePath = this.getAbsolutePathForRemoteArtifact(artifact, repository, request.getContext());
                this.checkFind(filePath, result);
                if (!result.isAvailable()) continue;
                break;
            }
        }
        return result;
    }

    private void checkFind(Path path, LocalArtifactResult result) {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            result.setPath(path);
            Properties props = this.readRepos(path);
            if (props.get(this.getKey(path, LOCAL_REPO_ID)) != null) {
                result.setAvailable(true);
            } else {
                String context = result.getRequest().getContext();
                for (RemoteRepository repository : result.getRequest().getRepositories()) {
                    if (props.get(this.getKey(path, this.getRepositoryKey(repository, context))) == null) continue;
                    result.setAvailable(true);
                    result.setRepository(repository);
                    break;
                }
                if (!result.isAvailable() && !this.isTracked(props, path)) {
                    result.setAvailable(true);
                }
            }
        }
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        Collection<String> repositories = request.getRepository() == null ? Collections.singleton(LOCAL_REPO_ID) : this.getRepositoryKeys(request.getRepository(), request.getContexts());
        if (request.getRepository() == null) {
            this.addArtifact(request.getArtifact(), repositories, null, null);
        } else {
            for (String context : request.getContexts()) {
                this.addArtifact(request.getArtifact(), repositories, request.getRepository(), context);
            }
        }
    }

    private Collection<String> getRepositoryKeys(RemoteRepository repository, Collection<String> contexts) {
        HashSet<String> keys = new HashSet<String>();
        if (contexts != null) {
            for (String context : contexts) {
                keys.add(this.getRepositoryKey(repository, context));
            }
        }
        return keys;
    }

    private void addArtifact(Artifact artifact, Collection<String> repositories, RemoteRepository repository, String context) {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        Path file = repository == null ? this.getAbsolutePathForLocalArtifact(artifact) : this.getAbsolutePathForRemoteArtifact(artifact, repository, context);
        this.addRepo(file, repositories);
    }

    private Properties readRepos(Path artifactPath) {
        Path trackingFile = this.getTrackingFile(artifactPath);
        Properties props = this.trackingFileManager.read(trackingFile);
        return props != null ? props : new Properties();
    }

    private void addRepo(Path artifactPath, Collection<String> repositories) {
        HashMap<String, String> updates = new HashMap<String, String>();
        for (String repository : repositories) {
            updates.put(this.getKey(artifactPath, repository), LOCAL_REPO_ID);
        }
        Path trackingPath = this.getTrackingFile(artifactPath);
        this.trackingFileManager.update(trackingPath, updates);
    }

    private Path getTrackingFile(Path artifactPath) {
        return artifactPath.getParent().resolve(this.trackingFilename);
    }

    private String getKey(Path path, String repository) {
        return path.getFileName() + ">" + repository;
    }

    private boolean isTracked(Properties props, Path path) {
        if (props != null) {
            String keyPrefix = path.getFileName() + ">";
            for (Object key : props.keySet()) {
                if (!key.toString().startsWith(keyPrefix)) continue;
                return true;
            }
        }
        return false;
    }
}

