/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.metadata.MergeableMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.spi.artifact.generator.ArtifactGenerator;
import org.eclipse.aether.spi.artifact.generator.ArtifactGeneratorFactory;
import org.eclipse.aether.spi.io.PathProcessor;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultInstaller
implements Installer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PathProcessor pathProcessor;
    private final RepositoryEventDispatcher repositoryEventDispatcher;
    private final Map<String, ArtifactGeneratorFactory> artifactFactories;
    private final Map<String, MetadataGeneratorFactory> metadataFactories;
    private final SyncContextFactory syncContextFactory;

    @Inject
    public DefaultInstaller(PathProcessor pathProcessor, RepositoryEventDispatcher repositoryEventDispatcher, Map<String, ArtifactGeneratorFactory> artifactFactories, Map<String, MetadataGeneratorFactory> metadataFactories, SyncContextFactory syncContextFactory) {
        this.pathProcessor = Objects.requireNonNull(pathProcessor, "path processor cannot be null");
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repository event dispatcher cannot be null");
        this.artifactFactories = Collections.unmodifiableMap(artifactFactories);
        this.metadataFactories = Collections.unmodifiableMap(metadataFactories);
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
    }

    @Override
    public InstallResult install(RepositorySystemSession session, InstallRequest request) throws InstallationException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        try (SyncContext syncContext = this.syncContextFactory.newInstance(session, false);){
            InstallResult installResult = this.install(syncContext, session, request);
            return installResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstallResult install(SyncContext syncContext, RepositorySystemSession session, InstallRequest request) throws InstallationException {
        InstallResult result = new InstallResult(request);
        RequestTrace trace = RequestTrace.newChild((RequestTrace)request.getTrace(), (Object)request);
        ArrayList artifacts = new ArrayList(request.getArtifacts());
        List<? extends ArtifactGenerator> artifactGenerators = this.getArtifactGenerators(session, request);
        try {
            ArrayList<Artifact> generatedArtifacts = new ArrayList<Artifact>();
            for (ArtifactGenerator artifactGenerator : artifactGenerators) {
                Collection generated = artifactGenerator.generate(generatedArtifacts);
                for (Artifact generatedArtifact : generated) {
                    HashMap<String, String> hashMap = new HashMap<String, String>(generatedArtifact.getProperties());
                    hashMap.put("artifactGeneratorId", Objects.requireNonNull(artifactGenerator.generatorId(), "generatorId"));
                    Artifact artifact = generatedArtifact.setProperties(hashMap);
                    generatedArtifacts.add(artifact);
                }
            }
            artifacts.addAll(generatedArtifacts);
            List<? extends MetadataGenerator> metadataGenerators = this.getMetadataGenerators(session, request);
            IdentityHashMap identityHashMap = new IdentityHashMap();
            List<Metadata> metadatas = Utils.prepareMetadata(metadataGenerators, artifacts);
            syncContext.acquire(artifacts, Utils.combine(request.getMetadata(), metadatas));
            for (Metadata metadata : metadatas) {
                this.install(session, trace, metadata);
                identityHashMap.put(metadata, null);
                result.addMetadata(metadata);
            }
            ListIterator<Artifact> iterator = artifacts.listIterator();
            while (iterator.hasNext()) {
                Artifact artifact = (Artifact)iterator.next();
                for (MetadataGenerator metadataGenerator : metadataGenerators) {
                    artifact = metadataGenerator.transformArtifact(artifact);
                }
                iterator.set(artifact);
                this.install(session, trace, artifact);
                if (artifact.getProperty("artifactGeneratorId", null) != null) continue;
                result.addArtifact(artifact);
            }
            metadatas = Utils.finishMetadata(metadataGenerators, artifacts);
            syncContext.acquire(null, metadatas);
            for (Metadata metadata : metadatas) {
                this.install(session, trace, metadata);
                identityHashMap.put(metadata, null);
                result.addMetadata(metadata);
            }
            for (Metadata metadata : request.getMetadata()) {
                if (identityHashMap.containsKey(metadata)) continue;
                this.install(session, trace, metadata);
                result.addMetadata(metadata);
            }
            Iterator<Object> iterator2 = result;
            return iterator2;
        }
        finally {
            for (ArtifactGenerator artifactGenerator : artifactGenerators) {
                try {
                    artifactGenerator.close();
                }
                catch (Exception exception) {
                    this.logger.warn("ArtifactGenerator close failure: {}", (Object)artifactGenerator.generatorId(), (Object)exception);
                }
            }
        }
    }

    private List<? extends ArtifactGenerator> getArtifactGenerators(RepositorySystemSession session, InstallRequest request) {
        PrioritizedComponents<ArtifactGeneratorFactory> factories = Utils.sortArtifactGeneratorFactories(session, this.artifactFactories);
        ArrayList<ArtifactGenerator> generators = new ArrayList<ArtifactGenerator>();
        for (PrioritizedComponent<ArtifactGeneratorFactory> factory : factories.getEnabled()) {
            ArtifactGenerator generator = factory.getComponent().newInstance(session, request);
            if (generator == null) continue;
            generators.add(generator);
        }
        return generators;
    }

    private List<? extends MetadataGenerator> getMetadataGenerators(RepositorySystemSession session, InstallRequest request) {
        PrioritizedComponents<MetadataGeneratorFactory> factories = Utils.sortMetadataGeneratorFactories(session, this.metadataFactories);
        ArrayList<MetadataGenerator> generators = new ArrayList<MetadataGenerator>();
        for (PrioritizedComponent<MetadataGeneratorFactory> factory : factories.getEnabled()) {
            MetadataGenerator generator = factory.getComponent().newInstance(session, request);
            if (generator == null) continue;
            generators.add(generator);
        }
        return generators;
    }

    private void install(RepositorySystemSession session, RequestTrace trace, Artifact artifact) throws InstallationException {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        Path srcPath = artifact.getPath();
        Path dstPath = lrm.getRepository().getBasePath().resolve(lrm.getPathForLocalArtifact(artifact));
        this.artifactInstalling(session, trace, artifact, dstPath);
        Exception exception = null;
        try {
            if (dstPath.equals(srcPath)) {
                throw new IllegalStateException("cannot install " + dstPath + " to same path");
            }
            this.pathProcessor.copy(srcPath, dstPath);
            Files.setLastModifiedTime(dstPath, Files.getLastModifiedTime(srcPath, new LinkOption[0]));
            lrm.add(session, new LocalArtifactRegistration(artifact));
        }
        catch (Exception e) {
            exception = e;
            throw new InstallationException("Failed to install artifact " + artifact + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.artifactInstalled(session, trace, artifact, dstPath, exception);
        }
    }

    private void install(RepositorySystemSession session, RequestTrace trace, Metadata metadata) throws InstallationException {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        Path dstPath = lrm.getRepository().getBasePath().resolve(lrm.getPathForLocalMetadata(metadata));
        this.metadataInstalling(session, trace, metadata, dstPath);
        Exception exception = null;
        try {
            if (metadata instanceof MergeableMetadata) {
                ((MergeableMetadata)metadata).merge(dstPath, dstPath);
            } else {
                if (dstPath.equals(metadata.getPath())) {
                    throw new IllegalStateException("cannot install " + dstPath + " to same path");
                }
                this.pathProcessor.copy(metadata.getPath(), dstPath);
            }
            lrm.add(session, new LocalMetadataRegistration(metadata));
        }
        catch (Exception e) {
            exception = e;
            throw new InstallationException("Failed to install metadata " + metadata + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.metadataInstalled(session, trace, metadata, dstPath, exception);
        }
    }

    private void artifactInstalling(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Path dstPath) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_INSTALLING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository((ArtifactRepository)session.getLocalRepositoryManager().getRepository());
        event.setPath(dstPath);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactInstalled(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Path dstPath, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_INSTALLED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository((ArtifactRepository)session.getLocalRepositoryManager().getRepository());
        event.setPath(dstPath);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataInstalling(RepositorySystemSession session, RequestTrace trace, Metadata metadata, Path dstPath) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INSTALLING);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository((ArtifactRepository)session.getLocalRepositoryManager().getRepository());
        event.setPath(dstPath);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataInstalled(RepositorySystemSession session, RequestTrace trace, Metadata metadata, Path dstPath, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INSTALLED);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository((ArtifactRepository)session.getLocalRepositoryManager().getRepository());
        event.setPath(dstPath);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }
}

