/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.UpdateCheck;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.DefaultUpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.AuthenticationDigest;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultUpdateCheckManager
implements UpdateCheckManager,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUpdatePolicyAnalyzer.class);
    private TrackingFileManager trackingFileManager;
    private UpdatePolicyAnalyzer updatePolicyAnalyzer;
    private static final String UPDATED_KEY_SUFFIX = ".lastUpdated";
    private static final String ERROR_KEY_SUFFIX = ".error";
    private static final String NOT_FOUND = "";
    private static final String SESSION_CHECKS = "updateCheckManager.checks";
    static final String CONFIG_PROP_SESSION_STATE = "aether.updateCheckManager.sessionState";
    private static final int STATE_ENABLED = 0;
    private static final int STATE_BYPASS = 1;
    private static final int STATE_DISABLED = 2;

    public DefaultUpdateCheckManager() {
    }

    @Inject
    DefaultUpdateCheckManager(TrackingFileManager trackingFileManager, UpdatePolicyAnalyzer updatePolicyAnalyzer) {
        this.setTrackingFileManager(trackingFileManager);
        this.setUpdatePolicyAnalyzer(updatePolicyAnalyzer);
    }

    public void initService(ServiceLocator locator) {
        this.setTrackingFileManager((TrackingFileManager)locator.getService(TrackingFileManager.class));
        this.setUpdatePolicyAnalyzer((UpdatePolicyAnalyzer)locator.getService(UpdatePolicyAnalyzer.class));
    }

    public DefaultUpdateCheckManager setTrackingFileManager(TrackingFileManager trackingFileManager) {
        this.trackingFileManager = Objects.requireNonNull(trackingFileManager);
        return this;
    }

    public DefaultUpdateCheckManager setUpdatePolicyAnalyzer(UpdatePolicyAnalyzer updatePolicyAnalyzer) {
        this.updatePolicyAnalyzer = Objects.requireNonNull(updatePolicyAnalyzer, "update policy analyzer cannot be null");
        return this;
    }

    @Override
    public void checkArtifact(RepositorySystemSession session, UpdateCheck<Artifact, ArtifactTransferException> check) {
        long lastUpdated;
        if (check.getLocalLastUpdated() != 0L && !this.isUpdatedRequired(session, check.getLocalLastUpdated(), check.getPolicy())) {
            LOGGER.debug("Skipped remote request for {}, locally installed artifact up-to-date", (Object)check.getItem());
            check.setRequired(false);
            return;
        }
        Artifact artifact = check.getItem();
        RemoteRepository repository = check.getRepository();
        File artifactFile = Objects.requireNonNull(check.getFile(), String.format("The artifact '%s' has no file attached", artifact));
        boolean fileExists = check.isFileValid() && artifactFile.exists();
        File touchFile = this.getArtifactTouchFile(artifactFile);
        Properties props = this.read(touchFile);
        String updateKey = this.getUpdateKey(session, artifactFile, repository);
        String dataKey = this.getDataKey(repository);
        String error = this.getError(props, dataKey);
        if (error == null) {
            lastUpdated = fileExists ? artifactFile.lastModified() : 0L;
        } else if (error.length() <= 0) {
            lastUpdated = this.getLastUpdated(props, dataKey);
        } else {
            String transferKey = this.getTransferKey(session, repository);
            lastUpdated = this.getLastUpdated(props, transferKey);
        }
        if (lastUpdated == 0L) {
            check.setRequired(true);
        } else if (this.isAlreadyUpdated(session, updateKey)) {
            LOGGER.debug("Skipped remote request for {}, already updated during this session", (Object)check.getItem());
            check.setRequired(false);
            if (error != null) {
                check.setException(this.newException(error, artifact, repository));
            }
        } else if (this.isUpdatedRequired(session, lastUpdated, check.getPolicy())) {
            check.setRequired(true);
        } else if (fileExists) {
            LOGGER.debug("Skipped remote request for {}, locally cached artifact up-to-date", (Object)check.getItem());
            check.setRequired(false);
        } else {
            int cacheFlag;
            int errorPolicy = Utils.getPolicy(session, artifact, repository);
            if ((errorPolicy & (cacheFlag = DefaultUpdateCheckManager.getCacheFlag(error))) != 0) {
                check.setRequired(false);
                check.setException(this.newException(error, artifact, repository));
            } else {
                check.setRequired(true);
            }
        }
    }

    private static int getCacheFlag(String error) {
        if (error == null || error.length() <= 0) {
            return 1;
        }
        return 2;
    }

    private ArtifactTransferException newException(String error, Artifact artifact, RemoteRepository repository) {
        if (error == null || error.length() <= 0) {
            return new ArtifactNotFoundException(artifact, repository, artifact + " was not found in " + repository.getUrl() + " during a previous attempt. This failure was cached in the local repository and resolution is not reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced", true);
        }
        return new ArtifactTransferException(artifact, repository, artifact + " failed to transfer from " + repository.getUrl() + " during a previous attempt. This failure was cached in the local repository and resolution is not reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced. Original error: " + error, true);
    }

    @Override
    public void checkMetadata(RepositorySystemSession session, UpdateCheck<Metadata, MetadataTransferException> check) {
        long lastUpdated;
        if (check.getLocalLastUpdated() != 0L && !this.isUpdatedRequired(session, check.getLocalLastUpdated(), check.getPolicy())) {
            LOGGER.debug("Skipped remote request for {} locally installed metadata up-to-date", (Object)check.getItem());
            check.setRequired(false);
            return;
        }
        Metadata metadata = check.getItem();
        RemoteRepository repository = check.getRepository();
        File metadataFile = Objects.requireNonNull(check.getFile(), String.format("The metadata '%s' has no file attached", metadata));
        boolean fileExists = check.isFileValid() && metadataFile.exists();
        File touchFile = this.getMetadataTouchFile(metadataFile);
        Properties props = this.read(touchFile);
        String updateKey = this.getUpdateKey(session, metadataFile, repository);
        String dataKey = this.getDataKey(metadataFile);
        String error = this.getError(props, dataKey);
        if (error == null) {
            lastUpdated = fileExists ? this.getLastUpdated(props, dataKey) : 0L;
        } else if (error.length() <= 0) {
            lastUpdated = this.getLastUpdated(props, dataKey);
        } else {
            String transferKey = this.getTransferKey(session, metadataFile, repository);
            lastUpdated = this.getLastUpdated(props, transferKey);
        }
        if (lastUpdated == 0L) {
            check.setRequired(true);
        } else if (this.isAlreadyUpdated(session, updateKey)) {
            LOGGER.debug("Skipped remote request for {}, already updated during this session", (Object)check.getItem());
            check.setRequired(false);
            if (error != null) {
                check.setException(this.newException(error, metadata, repository));
            }
        } else if (this.isUpdatedRequired(session, lastUpdated, check.getPolicy())) {
            check.setRequired(true);
        } else if (fileExists) {
            LOGGER.debug("Skipped remote request for {}, locally cached metadata up-to-date", (Object)check.getItem());
            check.setRequired(false);
        } else {
            int cacheFlag;
            int errorPolicy = Utils.getPolicy(session, metadata, repository);
            if ((errorPolicy & (cacheFlag = DefaultUpdateCheckManager.getCacheFlag(error))) != 0) {
                check.setRequired(false);
                check.setException(this.newException(error, metadata, repository));
            } else {
                check.setRequired(true);
            }
        }
    }

    private MetadataTransferException newException(String error, Metadata metadata, RemoteRepository repository) {
        if (error == null || error.length() <= 0) {
            return new MetadataNotFoundException(metadata, repository, metadata + " was not found in " + repository.getUrl() + " during a previous attempt. This failure was cached in the local repository and resolution is not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced", true);
        }
        return new MetadataTransferException(metadata, repository, metadata + " failed to transfer from " + repository.getUrl() + " during a previous attempt. This failure was cached in the local repository and resolution will not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced. Original error: " + error, true);
    }

    private long getLastUpdated(Properties props, String key) {
        String value = props.getProperty(key + UPDATED_KEY_SUFFIX, NOT_FOUND);
        try {
            return value.length() > 0 ? Long.parseLong(value) : 1L;
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Cannot parse last updated date {}, ignoring it", (Object)value, (Object)e);
            return 1L;
        }
    }

    private String getError(Properties props, String key) {
        return props.getProperty(key + ERROR_KEY_SUFFIX);
    }

    private File getArtifactTouchFile(File artifactFile) {
        return new File(artifactFile.getPath() + UPDATED_KEY_SUFFIX);
    }

    private File getMetadataTouchFile(File metadataFile) {
        return new File(metadataFile.getParent(), "resolver-status.properties");
    }

    private String getDataKey(RemoteRepository repository) {
        Set<String> mirroredUrls = Collections.emptySet();
        if (repository.isRepositoryManager()) {
            mirroredUrls = new TreeSet<String>();
            for (RemoteRepository mirroredRepository : repository.getMirroredRepositories()) {
                mirroredUrls.add(this.normalizeRepoUrl(mirroredRepository.getUrl()));
            }
        }
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append(this.normalizeRepoUrl(repository.getUrl()));
        for (String mirroredUrl : mirroredUrls) {
            buffer.append('+').append(mirroredUrl);
        }
        return buffer.toString();
    }

    private String getTransferKey(RepositorySystemSession session, RemoteRepository repository) {
        return this.getRepoKey(session, repository);
    }

    private String getDataKey(File metadataFile) {
        return metadataFile.getName();
    }

    private String getTransferKey(RepositorySystemSession session, File metadataFile, RemoteRepository repository) {
        return metadataFile.getName() + '/' + this.getRepoKey(session, repository);
    }

    private String getRepoKey(RepositorySystemSession session, RemoteRepository repository) {
        StringBuilder buffer = new StringBuilder(128);
        Proxy proxy = repository.getProxy();
        if (proxy != null) {
            buffer.append(AuthenticationDigest.forProxy((RepositorySystemSession)session, (RemoteRepository)repository)).append('@');
            buffer.append(proxy.getHost()).append(':').append(proxy.getPort()).append('>');
        }
        buffer.append(AuthenticationDigest.forRepository((RepositorySystemSession)session, (RemoteRepository)repository)).append('@');
        buffer.append(repository.getContentType()).append('-');
        buffer.append(repository.getId()).append('-');
        buffer.append(this.normalizeRepoUrl(repository.getUrl()));
        return buffer.toString();
    }

    private String normalizeRepoUrl(String url) {
        String result = url;
        if (url != null && url.length() > 0 && !url.endsWith("/")) {
            result = url + '/';
        }
        return result;
    }

    private String getUpdateKey(RepositorySystemSession session, File file, RemoteRepository repository) {
        return file.getAbsolutePath() + '|' + this.getRepoKey(session, repository);
    }

    private int getSessionState(RepositorySystemSession session) {
        String mode = ConfigUtils.getString((RepositorySystemSession)session, (String)"enabled", (String[])new String[]{CONFIG_PROP_SESSION_STATE});
        if (Boolean.parseBoolean(mode) || "enabled".equalsIgnoreCase(mode)) {
            return 0;
        }
        if ("bypass".equalsIgnoreCase(mode)) {
            return 1;
        }
        return 2;
    }

    private boolean isAlreadyUpdated(RepositorySystemSession session, Object updateKey) {
        if (this.getSessionState(session) >= 1) {
            return false;
        }
        SessionData data = session.getData();
        Object checkedFiles = data.get((Object)SESSION_CHECKS);
        if (!(checkedFiles instanceof Map)) {
            return false;
        }
        return ((Map)checkedFiles).containsKey(updateKey);
    }

    private void setUpdated(RepositorySystemSession session, Object updateKey) {
        ConcurrentHashMap old;
        if (this.getSessionState(session) >= 2) {
            return;
        }
        SessionData data = session.getData();
        Object checkedFiles = data.get((Object)SESSION_CHECKS);
        while (!(checkedFiles instanceof Map) && !data.set((Object)SESSION_CHECKS, old = checkedFiles, checkedFiles = new ConcurrentHashMap(256))) {
            checkedFiles = data.get((Object)SESSION_CHECKS);
        }
        ((Map)checkedFiles).put(updateKey, Boolean.TRUE);
    }

    private boolean isUpdatedRequired(RepositorySystemSession session, long lastModified, String policy) {
        return this.updatePolicyAnalyzer.isUpdatedRequired(session, lastModified, policy);
    }

    private Properties read(File touchFile) {
        Properties props = this.trackingFileManager.read(touchFile);
        return props != null ? props : new Properties();
    }

    @Override
    public void touchArtifact(RepositorySystemSession session, UpdateCheck<Artifact, ArtifactTransferException> check) {
        File artifactFile = check.getFile();
        File touchFile = this.getArtifactTouchFile(artifactFile);
        String updateKey = this.getUpdateKey(session, artifactFile, check.getRepository());
        String dataKey = this.getDataKey(check.getAuthoritativeRepository());
        String transferKey = this.getTransferKey(session, check.getRepository());
        this.setUpdated(session, updateKey);
        Properties props = this.write(touchFile, dataKey, transferKey, (Exception)((Object)check.getException()));
        if (artifactFile.exists() && !this.hasErrors(props)) {
            touchFile.delete();
        }
    }

    private boolean hasErrors(Properties props) {
        for (Object key : props.keySet()) {
            if (!key.toString().endsWith(ERROR_KEY_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void touchMetadata(RepositorySystemSession session, UpdateCheck<Metadata, MetadataTransferException> check) {
        File metadataFile = check.getFile();
        File touchFile = this.getMetadataTouchFile(metadataFile);
        String updateKey = this.getUpdateKey(session, metadataFile, check.getRepository());
        String dataKey = this.getDataKey(metadataFile);
        String transferKey = this.getTransferKey(session, metadataFile, check.getRepository());
        this.setUpdated(session, updateKey);
        this.write(touchFile, dataKey, transferKey, (Exception)check.getException());
    }

    private Properties write(File touchFile, String dataKey, String transferKey, Exception error) {
        HashMap<String, String> updates = new HashMap<String, String>();
        String timestamp = Long.toString(System.currentTimeMillis());
        if (error == null) {
            updates.put(dataKey + ERROR_KEY_SUFFIX, null);
            updates.put(dataKey + UPDATED_KEY_SUFFIX, timestamp);
            updates.put(transferKey + UPDATED_KEY_SUFFIX, null);
        } else if (error instanceof ArtifactNotFoundException || error instanceof MetadataNotFoundException) {
            updates.put(dataKey + ERROR_KEY_SUFFIX, NOT_FOUND);
            updates.put(dataKey + UPDATED_KEY_SUFFIX, timestamp);
            updates.put(transferKey + UPDATED_KEY_SUFFIX, null);
        } else {
            String msg = error.getMessage();
            if (msg == null || msg.length() <= 0) {
                msg = error.getClass().getSimpleName();
            }
            updates.put(dataKey + ERROR_KEY_SUFFIX, msg);
            updates.put(dataKey + UPDATED_KEY_SUFFIX, null);
            updates.put(transferKey + UPDATED_KEY_SUFFIX, timestamp);
        }
        return this.trackingFileManager.update(touchFile, updates);
    }
}

