/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import java.util.List;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.internal.impl.collect.Args;
import org.eclipse.aether.internal.impl.collect.Results;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.version.Version;

class DefaultDependencyCollectionContext
implements DependencyCollectionContext {
    private final RepositorySystemSession session;
    private Artifact artifact;
    private Dependency dependency;
    private List<Dependency> managedDependencies;
    private CollectResult collectResult;
    private RequestTrace trace;
    private Args args;
    private Results results;
    private List<Dependency> dependencies;
    private List<RemoteRepository> repositories;
    private DependencySelector depSelector;
    private DependencyManager depManager;
    private DependencyTraverser depTraverser;
    private VersionFilter verFilter;
    private Version version;

    DefaultDependencyCollectionContext(RepositorySystemSession session, Artifact artifact, Dependency dependency, List<Dependency> managedDependencies) {
        this.session = session;
        this.artifact = dependency != null ? dependency.getArtifact() : artifact;
        this.dependency = dependency;
        this.managedDependencies = managedDependencies;
    }

    public void prepareDescent() {
        DependencySelector dependencySelector = this.session.getDependencySelector();
        DependencyManager dependencyManager = this.session.getDependencyManager();
        VersionFilter versionFilter = this.session.getVersionFilter();
        this.setDepSelector(dependencySelector != null ? dependencySelector.deriveChildSelector((DependencyCollectionContext)this) : null);
        this.setDepManager(dependencyManager != null ? dependencyManager.deriveChildManager((DependencyCollectionContext)this) : null);
        this.setDepTraverser(this.depTraverser != null ? this.depTraverser.deriveChildTraverser((DependencyCollectionContext)this) : null);
        this.setVerFilter(versionFilter != null ? versionFilter.deriveChildFilter((DependencyCollectionContext)this) : null);
    }

    public DefaultDependencyCollectionContext createChildContext() {
        DefaultDependencyCollectionContext childContext = new DefaultDependencyCollectionContext(this.getSession(), this.getArtifact(), this.getDependency(), this.getManagedDependencies());
        childContext.depSelector = this.getDepSelector() != null ? this.getDepSelector().deriveChildSelector((DependencyCollectionContext)this) : null;
        childContext.depManager = this.getDepManager() != null ? this.getDepManager().deriveChildManager((DependencyCollectionContext)this) : null;
        childContext.depTraverser = this.getDepTraverser() != null ? this.getDepTraverser().deriveChildTraverser((DependencyCollectionContext)this) : null;
        childContext.verFilter = this.getVerFilter() != null ? this.getVerFilter().deriveChildFilter((DependencyCollectionContext)this) : null;
        return childContext;
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public List<Dependency> getManagedDependencies() {
        return this.managedDependencies;
    }

    public CollectResult getCollectResult() {
        return this.collectResult;
    }

    public void setCollectResult(CollectResult collectResult) {
        this.collectResult = collectResult;
    }

    public Args getArgs() {
        return this.args;
    }

    public void setArgs(Args args) {
        this.args = args;
    }

    public Results getResults() {
        return this.results;
    }

    public void setResults(Results results) {
        this.results = results;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<RemoteRepository> repositories) {
        this.repositories = repositories;
    }

    public DependencySelector getDepSelector() {
        return this.depSelector;
    }

    public void setDepSelector(DependencySelector depSelector) {
        this.depSelector = depSelector;
    }

    public DependencyManager getDepManager() {
        return this.depManager;
    }

    public void setDepManager(DependencyManager depManager) {
        this.depManager = depManager;
    }

    public DependencyTraverser getDepTraverser() {
        return this.depTraverser;
    }

    public void setDepTraverser(DependencyTraverser depTraverser) {
        this.depTraverser = depTraverser;
    }

    public VersionFilter getVerFilter() {
        return this.verFilter;
    }

    public void setVerFilter(VersionFilter verFilter) {
        this.verFilter = verFilter;
    }

    public void setDependency(Dependency dependency) {
        this.artifact = dependency.getArtifact();
        this.dependency = dependency;
    }

    public void setManagedDependencies(List<Dependency> managedDependencies) {
        this.managedDependencies = managedDependencies;
    }

    public RequestTrace getTrace() {
        return this.trace;
    }

    public void setTrace(RequestTrace trace) {
        this.trace = trace;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String toString() {
        return String.valueOf(this.getDependency());
    }
}

