/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war;

import java.io.File;
import java.io.IOException;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.war.AbstractWarMojo;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.war.WarArchiver;

public class WarMojo
extends AbstractWarMojo {
    private String outputDirectory;
    private String warName;
    private String classifier;
    private WarArchiver warArchiver;
    private MavenProjectHelper projectHelper;
    private boolean primaryArtifact;

    protected String getClassifier() {
        return this.classifier;
    }

    protected static File getWarFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".war");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File warFile = WarMojo.getWarFile(new File(this.outputDirectory), this.warName, this.classifier);
        try {
            this.performPackaging(warFile);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error assembling WAR: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("Error assembling WAR", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error assembling WAR", (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error assembling WAR: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private void performPackaging(File warFile) throws IOException, ArchiverException, ManifestException, DependencyResolutionRequiredException, MojoExecutionException, MojoFailureException {
        this.buildExplodedWebapp(this.getWebappDirectory());
        this.getLog().info((CharSequence)("Generating war " + warFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.warArchiver);
        archiver.setOutputFile(warFile);
        this.warArchiver.addDirectory(this.getWebappDirectory(), this.getIncludes(), this.getExcludes());
        this.warArchiver.setWebxml(new File(this.getWebappDirectory(), "WEB-INF/web.xml"));
        archiver.createArchive(this.getProject(), this.archive);
        String classifier = this.classifier;
        if (classifier != null) {
            this.projectHelper.attachArtifact(this.getProject(), "war", classifier, warFile);
        } else {
            Artifact artifact = this.getProject().getArtifact();
            if (this.primaryArtifact) {
                artifact.setFile(warFile);
            } else if (artifact.getFile() == null || artifact.getFile().isDirectory()) {
                artifact.setFile(warFile);
            }
        }
    }
}

