/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.toolchain;

import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.toolchain.ToolchainsRequirement;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.ToolchainPrivate;

@Mojo(name="toolchain", defaultPhase=LifecyclePhase.VALIDATE, configurator="toolchains-requirement-configurator")
public class ToolchainMojo
extends AbstractMojo {
    @Component
    private ToolchainManagerPrivate toolchainManagerPrivate;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(required=true)
    private ToolchainsRequirement toolchains;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.toolchains == null) {
            this.getLog().warn((CharSequence)"No toolchains requirements configured.");
            return;
        }
        ArrayList<String> nonMatchedTypes = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : this.toolchains.getToolchains().entrySet()) {
            String type = entry.getKey();
            if (this.selectToolchain(type, entry.getValue())) continue;
            nonMatchedTypes.add(type);
        }
        if (!nonMatchedTypes.isEmpty()) {
            StringBuilder buff = new StringBuilder();
            buff.append("Cannot find matching toolchain definitions for the following toolchain types:");
            for (String type : nonMatchedTypes) {
                buff.append(System.lineSeparator());
                buff.append(this.getToolchainRequirementAsString(type, this.toolchains.getParams(type)));
            }
            this.getLog().error((CharSequence)buff.toString());
            throw new MojoFailureException(buff.toString() + System.lineSeparator() + "Please make sure you define the required toolchains in your ~/.m2/toolchains.xml file.");
        }
    }

    protected String getToolchainRequirementAsString(String type, Map<String, String> params) {
        StringBuilder buff = new StringBuilder();
        buff.append(type).append(" [");
        if (params.size() == 0) {
            buff.append(" any");
        } else {
            for (Map.Entry<String, String> param : params.entrySet()) {
                buff.append(" ").append(param.getKey()).append("='").append(param.getValue());
                buff.append("'");
            }
        }
        buff.append(" ]");
        return buff.toString();
    }

    protected boolean selectToolchain(String type, Map<String, String> params) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Required toolchain: " + this.getToolchainRequirementAsString(type, params)));
        int typeFound = 0;
        try {
            ToolchainPrivate[] tcs;
            for (ToolchainPrivate tc : tcs = this.getToolchains(type)) {
                if (!type.equals(tc.getType())) continue;
                ++typeFound;
                if (!tc.matchesRequirements(params)) continue;
                this.getLog().info((CharSequence)("Found matching toolchain for type " + type + ": " + tc));
                this.toolchainManagerPrivate.storeToolchainToBuildContext(tc, this.session);
                return true;
            }
        }
        catch (MisconfiguredToolchainException ex) {
            throw new MojoExecutionException("Misconfigured toolchains.", (Exception)((Object)ex));
        }
        this.getLog().error((CharSequence)("No toolchain " + (typeFound == 0 ? "found" : "matched from " + typeFound + " found") + " for type " + type));
        return false;
    }

    private ToolchainPrivate[] getToolchains(String type) throws MojoExecutionException, MisconfiguredToolchainException {
        return this.toolchainManagerPrivate.getToolchainsForType(type, this.session);
    }
}

