/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.source;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-source-plugin:2.1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Source Plugin", 0);
        this.append(sb, "The Maven 2 Source Plugin creates a JAR archive of the source files of the current project.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 6 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "aggregate".equals(this.goal)) {
            this.append(sb, "source:aggregate", 0);
            this.append(sb, "Aggregate sources for all modules in an aggregator project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attach (Default: true)", 2);
                this.append(sb, "Specifies whether or not to attach the artifact to the project", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeResources (Default: false)", 2);
                this.append(sb, "Specifies whether or not to exclude resources from the sources-jar. This can be convenient if your project includes large resources, such as images, and you don't want to include them in the sources-jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The filename to be used for the generated archive file. For the source:jar goal, '-sources' is appended to this filename. For the source:test-jar goal, '-test-sources' is appended.", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceCreation (Default: false)", 2);
                this.append(sb, "Whether creating the archive should be forced. If set to true, the jar will always be created. If set to false, the jar will only be created when the sources are newer than the jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includePom (Default: false)", 2);
                this.append(sb, "Specifies whether or not to include the POM file in the sources-jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory where the generated archive file will be put.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultExcludes (Default: true)", 2);
                this.append(sb, "Exclude commonly excluded files such as SCM configuration. These are defined in the plexus FileUtils.getDefaultExcludes()", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultManifestFile (Default: false)", 2);
                this.append(sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "source:help", 0);
            this.append(sb, "Display help information on maven-source-plugin.\nCall\n\u00a0\u00a0mvn\u00a0source:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jar".equals(this.goal)) {
            this.append(sb, "source:jar", 0);
            this.append(sb, "This plugin bundles all the sources into a jar archive.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attach (Default: true)", 2);
                this.append(sb, "Specifies whether or not to attach the artifact to the project", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeResources (Default: false)", 2);
                this.append(sb, "Specifies whether or not to exclude resources from the sources-jar. This can be convenient if your project includes large resources, such as images, and you don't want to include them in the sources-jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The filename to be used for the generated archive file. For the source:jar goal, '-sources' is appended to this filename. For the source:test-jar goal, '-test-sources' is appended.", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceCreation (Default: false)", 2);
                this.append(sb, "Whether creating the archive should be forced. If set to true, the jar will always be created. If set to false, the jar will only be created when the sources are newer than the jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includePom (Default: false)", 2);
                this.append(sb, "Specifies whether or not to include the POM file in the sources-jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory where the generated archive file will be put.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultExcludes (Default: true)", 2);
                this.append(sb, "Exclude commonly excluded files such as SCM configuration. These are defined in the plexus FileUtils.getDefaultExcludes()", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultManifestFile (Default: false)", 2);
                this.append(sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jar-no-fork".equals(this.goal)) {
            this.append(sb, "source:jar-no-fork", 0);
            this.append(sb, "This goal bundles all the sources into a jar archive. This goal functions the same as the jar goal but does not fork the build and is suitable for attaching to the build lifecycle.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attach (Default: true)", 2);
                this.append(sb, "Specifies whether or not to attach the artifact to the project", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeResources (Default: false)", 2);
                this.append(sb, "Specifies whether or not to exclude resources from the sources-jar. This can be convenient if your project includes large resources, such as images, and you don't want to include them in the sources-jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The filename to be used for the generated archive file. For the source:jar goal, '-sources' is appended to this filename. For the source:test-jar goal, '-test-sources' is appended.", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceCreation (Default: false)", 2);
                this.append(sb, "Whether creating the archive should be forced. If set to true, the jar will always be created. If set to false, the jar will only be created when the sources are newer than the jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includePom (Default: false)", 2);
                this.append(sb, "Specifies whether or not to include the POM file in the sources-jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory where the generated archive file will be put.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultExcludes (Default: true)", 2);
                this.append(sb, "Exclude commonly excluded files such as SCM configuration. These are defined in the plexus FileUtils.getDefaultExcludes()", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultManifestFile (Default: false)", 2);
                this.append(sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test-jar".equals(this.goal)) {
            this.append(sb, "source:test-jar", 0);
            this.append(sb, "This plugin bundles all the test sources into a jar archive.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attach (Default: true)", 2);
                this.append(sb, "Specifies whether or not to attach the artifact to the project", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeResources (Default: false)", 2);
                this.append(sb, "Specifies whether or not to exclude resources from the sources-jar. This can be convenient if your project includes large resources, such as images, and you don't want to include them in the sources-jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The filename to be used for the generated archive file. For the source:jar goal, '-sources' is appended to this filename. For the source:test-jar goal, '-test-sources' is appended.", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceCreation (Default: false)", 2);
                this.append(sb, "Whether creating the archive should be forced. If set to true, the jar will always be created. If set to false, the jar will only be created when the sources are newer than the jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includePom (Default: false)", 2);
                this.append(sb, "Specifies whether or not to include the POM file in the sources-jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory where the generated archive file will be put.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultExcludes (Default: true)", 2);
                this.append(sb, "Exclude commonly excluded files such as SCM configuration. These are defined in the plexus FileUtils.getDefaultExcludes()", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultManifestFile (Default: false)", 2);
                this.append(sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test-jar-no-fork".equals(this.goal)) {
            this.append(sb, "source:test-jar-no-fork", 0);
            this.append(sb, "This goal bundles all the test sources into a jar archive. This goal functions the same as the test-jar goal but does not fork the build, and is suitable for attaching to the build lifecycle.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attach (Default: true)", 2);
                this.append(sb, "Specifies whether or not to attach the artifact to the project", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeResources (Default: false)", 2);
                this.append(sb, "Specifies whether or not to exclude resources from the sources-jar. This can be convenient if your project includes large resources, such as images, and you don't want to include them in the sources-jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The filename to be used for the generated archive file. For the source:jar goal, '-sources' is appended to this filename. For the source:test-jar goal, '-test-sources' is appended.", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceCreation (Default: false)", 2);
                this.append(sb, "Whether creating the archive should be forced. If set to true, the jar will always be created. If set to false, the jar will only be created when the sources are newer than the jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includePom (Default: false)", 2);
                this.append(sb, "Specifies whether or not to include the POM file in the sources-jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory where the generated archive file will be put.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultExcludes (Default: true)", 2);
                this.append(sb, "Exclude commonly excluded files such as SCM configuration. These are defined in the plexus FileUtils.getDefaultExcludes()", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultManifestFile (Default: false)", 2);
                this.append(sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

