/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.run;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.site.render.AbstractSiteRenderingMojo;
import org.apache.maven.plugins.site.run.DoxiaBean;
import org.apache.maven.reporting.exec.MavenReportExecution;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;

@Mojo(name="run", aggregator=true, requiresReports=true)
public class SiteRunMojo
extends AbstractSiteRenderingMojo {
    @Parameter(defaultValue="${project.build.directory}/site-webapp")
    private File tempWebappDirectory;
    @Parameter(property="port", defaultValue="8080")
    private int port;
    private static final int MAX_IDLE_TIME = 30000;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkInputEncoding();
        Server server = new Server(this.port);
        server.setStopAtShutdown(true);
        WebAppContext webapp = this.createWebApplication();
        webapp.setServer(server);
        server.setHandler((Handler)webapp);
        this.getLog().info((CharSequence)("Starting Jetty on http://localhost:" + this.port + "/"));
        try {
            server.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing Jetty: " + e.getMessage(), e);
        }
        try {
            server.getThreadPool().join();
        }
        catch (InterruptedException e) {
            this.getLog().warn((CharSequence)"Jetty was interrupted", (Throwable)e);
        }
    }

    private WebAppContext createWebApplication() throws MojoExecutionException {
        File webXml = new File(this.tempWebappDirectory, "WEB-INF/web.xml");
        webXml.getParentFile().mkdirs();
        try (InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream("/run/web.xml");
             FileOutputStream outStream = new FileOutputStream(webXml);){
            IOUtil.copy((InputStream)inStream, (OutputStream)outStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to construct temporary webapp for running site", (Exception)e);
        }
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        webapp.setResourceBase(this.tempWebappDirectory.getAbsolutePath());
        webapp.setAttribute("siteRenderer", (Object)this.siteRenderer);
        webapp.getInitParams().put("org.mortbay.jetty.servlet.Default.useFileMappedBuffer", "false");
        this.project.getReporting().setOutputDirectory(this.tempWebappDirectory.getAbsolutePath());
        for (MavenReportExecution mavenReportExecution : this.getReports()) {
            mavenReportExecution.getMavenReport().setReportOutputDirectory(this.tempWebappDirectory);
        }
        List<MavenReportExecution> reports = this.getReports();
        List<Locale> localesList = this.getLocales();
        webapp.setAttribute("localesList", localesList);
        Locale defaultLocale = localesList.get(0);
        Locale.setDefault(defaultLocale);
        try {
            HashMap<String, DoxiaBean> i18nDoxiaContexts = new HashMap<String, DoxiaBean>();
            for (Locale locale : localesList) {
                DoxiaBean doxiaBean;
                SiteRenderingContext i18nContext = this.createSiteRenderingContext(locale);
                i18nContext.setInputEncoding(this.getInputEncoding());
                i18nContext.setOutputEncoding(this.getOutputEncoding());
                SiteRenderingContext i18nGeneratedSiteContext = this.createSiteRenderingContext(locale);
                i18nGeneratedSiteContext.setInputEncoding(this.getInputEncoding());
                i18nGeneratedSiteContext.setOutputEncoding(this.getOutputEncoding());
                i18nGeneratedSiteContext.getSiteDirectories().clear();
                Map<String, DocumentRenderer> i18nDocuments = this.locateDocuments(i18nContext, reports, locale);
                if (defaultLocale.equals(locale)) {
                    i18nGeneratedSiteContext.addSiteDirectory(this.generatedSiteDirectory);
                    doxiaBean = new DoxiaBean(i18nContext, i18nDocuments, i18nGeneratedSiteContext);
                } else {
                    i18nGeneratedSiteContext.addSiteDirectory(new File(this.generatedSiteDirectory, locale.getLanguage()));
                    doxiaBean = new DoxiaBean(i18nContext, i18nDocuments, i18nGeneratedSiteContext);
                }
                i18nDoxiaContexts.put(locale.getLanguage(), doxiaBean);
                if (defaultLocale.equals(locale)) {
                    i18nDoxiaContexts.put("default", doxiaBean);
                }
                if (defaultLocale.equals(locale)) {
                    this.siteRenderer.copyResources(i18nContext, this.tempWebappDirectory);
                    continue;
                }
                this.siteRenderer.copyResources(i18nContext, new File(this.tempWebappDirectory, locale.getLanguage()));
            }
            webapp.setAttribute("i18nDoxiaContexts", i18nDoxiaContexts);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to set up webapp", e);
        }
        return webapp;
    }

    public void setTempWebappDirectory(File tempWebappDirectory) {
        this.tempWebappDirectory = tempWebappDirectory;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

