/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;

public class GroovyResourceTransformer
implements ResourceTransformer {
    static final String EXT_MODULE_NAME_LEGACY = "META-INF/services/org.codehaus.groovy.runtime.ExtensionModule";
    static final String EXT_MODULE_NAME = "META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule";
    private List<String> extensionClassesList = new ArrayList<String>();
    private List<String> staticExtensionClassesList = new ArrayList<String>();
    private String extModuleName = "no-module-name";
    private String extModuleVersion = "1.0";
    private long time = Long.MIN_VALUE;

    @Override
    public boolean canTransformResource(String resource) {
        return EXT_MODULE_NAME.equals(resource) || EXT_MODULE_NAME_LEGACY.equals(resource);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        String staticExtensionClasses;
        Properties out = new Properties();
        try (InputStream props = is;){
            out.load(props);
        }
        String extensionClasses = out.getProperty("extensionClasses", "").trim();
        if (extensionClasses.length() > 0) {
            this.append(extensionClasses, this.extensionClassesList);
        }
        if ((staticExtensionClasses = out.getProperty("staticExtensionClasses", "").trim()).length() > 0) {
            this.append(staticExtensionClasses, this.staticExtensionClassesList);
        }
        if (time > this.time) {
            this.time = time;
        }
    }

    private void append(String entry, List<String> list) {
        if (entry != null) {
            Collections.addAll(list, entry.split("\\s*,\\s*"));
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return this.extensionClassesList.size() > 0 && this.staticExtensionClassesList.size() > 0;
    }

    @Override
    public void modifyOutputStream(JarOutputStream os) throws IOException {
        if (this.hasTransformedResource()) {
            JarEntry jarEntry = new JarEntry(EXT_MODULE_NAME);
            jarEntry.setTime(this.time);
            os.putNextEntry(jarEntry);
            Properties desc = new Properties();
            desc.put("moduleName", this.extModuleName);
            desc.put("moduleVersion", this.extModuleVersion);
            if (this.extensionClassesList.size() > 0) {
                desc.put("extensionClasses", this.join(this.extensionClassesList));
            }
            if (this.staticExtensionClassesList.size() > 0) {
                desc.put("staticExtensionClasses", this.join(this.staticExtensionClassesList));
            }
            desc.store(os, null);
        }
    }

    private String join(Collection<String> strings) {
        Iterator<String> it = strings.iterator();
        switch (strings.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return it.next();
            }
        }
        StringBuilder buff = new StringBuilder(it.next());
        while (it.hasNext()) {
            buff.append(",").append(it.next());
        }
        return buff.toString();
    }

    public void setExtModuleName(String extModuleName) {
        this.extModuleName = extModuleName;
    }

    public void setExtModuleVersion(String extModuleVersion) {
        this.extModuleVersion = extModuleVersion;
    }
}

